#!/usr/bin/env python
# -*- coding: utf-8 -*-

import sys
import os
import xbmc
import xbmcgui
import xbmcaddon
import time
import decimal

# Get global paths
addon = xbmcaddon.Addon(id='plugin.program.piwire')
addonpath = addon.getAddonInfo('path').decode("utf-8")
monitor=xbmc.Monitor()

# Defaults
counter = 15
visible = 0
xbmcgui.Window(10000).setProperty('Temp1','n/a')
xbmcgui.Window(10000).setProperty('Temp2','n/a')
xbmcgui.Window(10000).setProperty('Temp3','n/a')
xbmcgui.Window(10000).setProperty('Temp4','n/a')
xbmcgui.Window(10000).setProperty('Temp5','n/a')
xbmcgui.Window(10000).setProperty('Temp6','n/a')
xbmcgui.Window(10000).setProperty('Temp7','n/a')
xbmcgui.Window(10000).setProperty('Temp8','n/a')
xbmcgui.Window(10000).setProperty('Trend1','')
xbmcgui.Window(10000).setProperty('Trend2','')
xbmcgui.Window(10000).setProperty('Trend3','')
xbmcgui.Window(10000).setProperty('Trend4','')
xbmcgui.Window(10000).setProperty('Trend5','')
xbmcgui.Window(10000).setProperty('Trend6','')
xbmcgui.Window(10000).setProperty('Trend7','')
xbmcgui.Window(10000).setProperty('Trend8','')

xbmcgui.Window(10000).setProperty('field1',addon.getSetting('field1'))
xbmcgui.Window(10000).setProperty('field2',addon.getSetting('field2'))
xbmcgui.Window(10000).setProperty('field3',addon.getSetting('field3'))
xbmcgui.Window(10000).setProperty('field4',addon.getSetting('field4'))
xbmcgui.Window(10000).setProperty('field5',addon.getSetting('field5'))
xbmcgui.Window(10000).setProperty('field6',addon.getSetting('field6'))
xbmcgui.Window(10000).setProperty('field7',addon.getSetting('field7'))
xbmcgui.Window(10000).setProperty('field8',addon.getSetting('field8'))

xbmcgui.Window(10000).setProperty('visible','0')



def initSensorlist():
    counter = 1
    sensorlist = ""
    file = open('/sys/devices/w1_bus_master1/w1_master_slaves')
    w1_slaves = file.readlines()
    file.close()
    for line in w1_slaves:
	w1_slave = line.split("\n")[0]
	if counter < 2:
	    sensorlist = "-," + str(w1_slave)
	else:
	    sensorlist = sensorlist + "," + str(w1_slave)
	counter = counter + 1
    addon.setSetting('sensorlist',str(sensorlist))

def readSensors():
    linenumber = 1
    sensor1 = addon.getSetting('fieldmap1')
    sensor2 = addon.getSetting('fieldmap2')
    sensor3 = addon.getSetting('fieldmap3')
    sensor4 = addon.getSetting('fieldmap4')
    sensor5 = addon.getSetting('fieldmap5')
    sensor6 = addon.getSetting('fieldmap6')
    sensor7 = addon.getSetting('fieldmap7')
    sensor8 = addon.getSetting('fieldmap8')
    visible = xbmcgui.Window(10000).getProperty('visible')

    if not os.path.exists('/sys/bus/w1/devices/' + str(sensor1)) and str(sensor1) != "-":
	xbmcgui.Window(10000).setProperty('Trend1','piwire_icon_missing.png')
	if addon.getSetting('sensormissing') == "true":
	    xbmcgui.Dialog().ok("$ADDON[plugin.program.piwire 30025]","$ADDON[plugin.program.piwire 30024]")
	if addon.getSetting('showdashboard') == "true" and visible == "0":
	    xbmc.executebuiltin('RunPlugin(plugin://plugin.program.piwire)')
	    xbmcgui.Window(10000).setProperty('visible','1')

    if not os.path.exists('/sys/bus/w1/devices/' + str(sensor2)) and str(sensor2) != "-":
	xbmcgui.Window(10000).setProperty('Trend2','piwire_icon_missing.png')
	if addon.getSetting('sensormissing') == "true":
	    xbmcgui.Dialog().ok("$ADDON[plugin.program.piwire 30025]","$ADDON[plugin.program.piwire 30024]")
	if addon.getSetting('showdashboard') == "true" and visible == "0":
	    xbmc.executebuiltin('RunPlugin(plugin://plugin.program.piwire)')
	    xbmcgui.Window(10000).setProperty('visible','1')

    if not os.path.exists('/sys/bus/w1/devices/' + str(sensor3)) and str(sensor3) != "-":
	xbmcgui.Window(10000).setProperty('Trend3','piwire_icon_missing.png')
	if addon.getSetting('sensormissing') == "true":
	    xbmcgui.Dialog().ok("$ADDON[plugin.program.piwire 30025]","$ADDON[plugin.program.piwire 30024]")
	if addon.getSetting('showdashboard') == "true" and visible == "0":
	    xbmc.executebuiltin('RunPlugin(plugin://plugin.program.piwire)')
	    xbmcgui.Window(10000).setProperty('visible','1')

    if not os.path.exists('/sys/bus/w1/devices/' + str(sensor4)) and str(sensor4) != "-":
	xbmcgui.Window(10000).setProperty('Trend4','piwire_icon_missing.png')
	if addon.getSetting('sensormissing') == "true":
	    xbmcgui.Dialog().ok("$ADDON[plugin.program.piwire 30025]","$ADDON[plugin.program.piwire 30024]")
	if addon.getSetting('showdashboard') == "true" and visible == "0":
	    xbmc.executebuiltin('RunPlugin(plugin://plugin.program.piwire)')
	    xbmcgui.Window(10000).setProperty('visible','1')

    if not os.path.exists('/sys/bus/w1/devices/' + str(sensor5)) and str(sensor5) != "-":
	xbmcgui.Window(10000).setProperty('Trend5','piwire_icon_missing.png')
	if addon.getSetting('sensormissing') == "true":
	    xbmcgui.Dialog().ok("$ADDON[plugin.program.piwire 30025]","$ADDON[plugin.program.piwire 30024]")
	if addon.getSetting('showdashboard') == "true" and visible == "0":
	    xbmc.executebuiltin('RunPlugin(plugin://plugin.program.piwire)')
	    xbmcgui.Window(10000).setProperty('visible','1')

    if not os.path.exists('/sys/bus/w1/devices/' + str(sensor6)) and str(sensor6) != "-":
	xbmcgui.Window(10000).setProperty('Trend6','piwire_icon_missing.png')
	if addon.getSetting('sensormissing') == "true":
	    xbmcgui.Dialog().ok("$ADDON[plugin.program.piwire 30025]","$ADDON[plugin.program.piwire 30024]")
	if addon.getSetting('showdashboard') == "true" and visible == "0":
	    xbmc.executebuiltin('RunPlugin(plugin://plugin.program.piwire)')
	    xbmcgui.Window(10000).setProperty('visible','1')

    if not os.path.exists('/sys/bus/w1/devices/' + str(sensor7)) and str(sensor7) != "-":
	xbmcgui.Window(10000).setProperty('Trend7','piwire_icon_missing.png')
	if addon.getSetting('sensormissing') == "true":
	    xbmcgui.Dialog().ok("$ADDON[plugin.program.piwire 30025]","$ADDON[plugin.program.piwire 30024]")
	if addon.getSetting('showdashboard') == "true" and visible == "0":
	    xbmc.executebuiltin('RunPlugin(plugin://plugin.program.piwire)')
	    xbmcgui.Window(10000).setProperty('visible','1')

    if not os.path.exists('/sys/bus/w1/devices/' + str(sensor8)) and str(sensor8) != "-":
	xbmcgui.Window(10000).setProperty('Trend8','piwire_icon_missing.png')
	if addon.getSetting('sensormissing') == "true":
	    xbmcgui.Dialog().ok("$ADDON[plugin.program.piwire 30025]","$ADDON[plugin.program.piwire 30024]")
	if addon.getSetting('showdashboard') == "true" and visible == "0":
	    xbmc.executebuiltin('RunPlugin(plugin://plugin.program.piwire)')
	    xbmcgui.Window(10000).setProperty('visible','1')

    file = open('/sys/devices/w1_bus_master1/w1_master_slaves')
    w1_slaves = file.readlines()
    file.close()
    for line in w1_slaves:
	w1_slave = line.split("\n")[0]
	file = open('/sys/bus/w1/devices/' + str(w1_slave) + '/w1_slave')
	filecontent = file.read()
	file.close()
	check = ""
	if str(w1_slave) == str(sensor1):
	    fieldmap = 1
	    check = "ok"
	if str(w1_slave) == str(sensor2):
	    fieldmap = 2
	    check = "ok"
	if str(w1_slave) == str(sensor3):
	    fieldmap = 3
	    check = "ok"
	if str(w1_slave) == str(sensor4):
	    fieldmap = 4
	    check = "ok"
	if str(w1_slave) == str(sensor5):
	    fieldmap = 5
	    check = "ok"
	if str(w1_slave) == str(sensor6):
	    fieldmap = 6
	    check = "ok"
	if str(w1_slave) == str(sensor7):
	    fieldmap = 7
	    check = "ok"
	if str(w1_slave) == str(sensor8):
	    fieldmap = 8
	    check = "ok"
	
	if check == "ok":
	    if "YES" in filecontent:
		stringvalue = filecontent.split("\n")[1].split(" ")[9]
    		temperaturefull = float(stringvalue[2:]) / 1000
    		temperature = round(temperaturefull,1)
		tempold = str(xbmcgui.Window(10000).getProperty('Temp' + str(fieldmap)))
    		if tempold == "n/a" or tempold == "error" or tempold == "":
	    	    tempold = temperature
    		else:
	    	    tempold = float(tempold)
    		if temperature > tempold:
	    	    xbmcgui.Window(10000).setProperty('Trend' + str(fieldmap),'piwire_icon_up.png')
    		if temperature < tempold:
	    	    xbmcgui.Window(10000).setProperty('Trend' + str(fieldmap),'piwire_icon_down.png')
    		if temperature == tempold:
	    	    xbmcgui.Window(10000).setProperty('Trend' + str(fieldmap),'piwire_dummy.png')
		xbmcgui.Window(10000).setProperty('Temp' + str(fieldmap),str(temperature))
		xbmcgui.Window(10000).setProperty('Text' + str(fieldmap),"°C")
		if temperature > int(addon.getSetting('warnlimit' + str(fieldmap))):
        	    xbmcgui.Dialog().notification("$ADDON[plugin.program.piwire 30020]","$ADDON[plugin.program.piwire 30049]" + " (" + addon.getSetting('field' + str(fieldmap)) + ")","piwire_icon_templimit.png",5000)
	    	    xbmcgui.Window(10000).setProperty('Trend' + str(fieldmap),'piwire_icon_templimit.png')
	    else:
		visible = xbmcgui.Window(10000).getProperty('visible')
		xbmcgui.Window(10000).setProperty('Text' + str(fieldmap),"")
		xbmcgui.Window(10000).setProperty('Temp' + str(fieldmap),"n/a")
		xbmcgui.Window(10000).setProperty('Trend' + str(fieldmap),'piwire_icon_warning.png')
		if addon.getSetting('showdashboard') == "true" and visible == "0":
		    xbmc.executebuiltin('RunPlugin(plugin://plugin.program.piwire)')
		    xbmcgui.Window(10000).setProperty('visible','1')
		if addon.getSetting('sensorreaderror') == "true":
        	    xbmcgui.Dialog().notification("$ADDON[plugin.program.piwire 30020]","$ADDON[plugin.program.piwire 30022]" + " (" + addon.getSetting('field' + str(fieldmap)) + ")","piwire_icon_warning.png",5000)
	    	    xbmcgui.Window(10000).setProperty('Trend' + str(fieldmap),'piwire_icon_warning.png')

	    linenumber = linenumber + 1

initSensorlist()
readSensors()

while True:
    if monitor.abortRequested():
	break
    counter = counter - 1
    if counter <= 0:
	counter = 15
	readSensors()
    time.sleep(1.0)
quit()
