#
# This is the server logic of a Shiny web application. You can run the 
# application by clicking 'Run App' above.
#
# Find out more about building applications with Shiny here:
# 
#    http://shiny.rstudio.com/
#

library(shiny)

# Define server logic required to draw a histogram
shinyServer(function(input, output) {

  output$ka_map <- renderLeaflet({
    leaflet() %>% addProviderTiles("Stamen.TonerLite") %>% 
      addPolylines(data=ka0, group="lines") %>% 
      addLegend("bottomright", colors="red", labels="Street Segment Speed Distribution")
  })
  
  output$text1 <- renderText({ 
    paste0("You have selected: ", input$std, " Uhr")
  })

  filtereddata <- reactive({
    get(eval(paste0("ka",input$std)))
  })
  
  observe({
    binpal <- colorBin("plasma", ka20$MEDIANSP.3, 5, pretty = FALSE)
    leafletProxy("ka_map") %>% 
      clearGroup(lines) %>% 
      addPolylines(data = filtereddata(),color = ~binpal(MEDIANSP.3))
  })
  
})
