#
# This is the user-interface definition of a Shiny web application. You can
# run the application by clicking 'Run App' above.
#
# Find out more about building applications with Shiny here:
# 
#    http://shiny.rstudio.com/
#

library(shiny)

# Define UI for application that draws a histogram
shinyUI(fluidPage(
  
  # Application title
  titlePanel("TomTom Daten Visualisierung"),
  
  sidebarLayout(
    sidebarPanel(
      sliderInput("std", "Stunde", min=0, max=23, value = 8, step = 1)
    ),
    mainPanel (
      textOutput("text1"),
      leafletOutput("ka_map")
    )
  )
))
