// Generated by CoffeeScript 1.8.0

/*
  Copyright (c) 2014 clowwindy
  
  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:
  
  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.
  
  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
  SOFTWARE.
 */

(function() {
  var pack, printLocalHelp, printServerHelp, util, _logging_level;

  util = require('util');

  pack = require('../../package.json');

  printLocalHelp = function() {
    return console.log("usage: sslocal [-h] -s SERVER_ADDR -p SERVER_PORT [-b LOCAL_ADDR] -l LOCAL_PORT -k PASSWORD -m METHOD [-t TIMEOUT] [-c config]\n\noptional arguments:\n  -h, --help            show this help message and exit\n  -s SERVER_ADDR        server address\n  -p SERVER_PORT        server port\n  -b LOCAL_ADDR         local binding address, default is 127.0.0.1\n  -l LOCAL_PORT         local port\n  -k PASSWORD           password\n  -m METHOD             encryption method, for example, aes-256-cfb\n  -t TIMEOUT            timeout in seconds\n  -c CONFIG             path to config file");
  };

  printServerHelp = function() {
    return console.log("usage: ssserver [-h] -s SERVER_ADDR -p SERVER_PORT -k PASSWORD -m METHOD [-t TIMEOUT] [-c config]\n\noptional arguments:\n  -h, --help            show this help message and exit\n  -s SERVER_ADDR        server address\n  -p SERVER_PORT        server port\n  -k PASSWORD           password\n  -m METHOD             encryption method, for example, aes-256-cfb\n  -t TIMEOUT            timeout in seconds\n  -c CONFIG             path to config file");
  };

  exports.parseArgs = function(isServer) {
    var defination, lastKey, nextIsValue, oneArg, result, _, _ref;
    if (isServer == null) {
      isServer = false;
    }
    defination = {
      '-l': 'local_port',
      '-p': 'server_port',
      '-s': 'server',
      '-k': 'password',
      '-c': 'config_file',
      '-m': 'method',
      '-b': 'local_address',
      '-t': 'timeout'
    };
    result = {};
    nextIsValue = false;
    lastKey = null;
    _ref = process.argv;
    for (_ in _ref) {
      oneArg = _ref[_];
      if (nextIsValue) {
        result[lastKey] = oneArg;
        nextIsValue = false;
      } else if (oneArg in defination) {
        lastKey = defination[oneArg];
        nextIsValue = true;
      } else if ('-v' === oneArg) {
        result['verbose'] = true;
      } else if (oneArg.indexOf('-') === 0) {
        if (isServer) {
          printServerHelp();
        } else {
          printLocalHelp();
        }
        process.exit(2);
      }
    }
    return result;
  };

  exports.checkConfig = function(config) {
    var _ref;
    if ((_ref = config.server) === '127.0.0.1' || _ref === 'localhost') {
      exports.warn("Server is set to " + config.server + ", maybe it's not correct");
      exports.warn("Notice server will listen at " + config.server + ":" + config.server_port);
    }
    if ((config.method || '').toLowerCase() === 'rc4') {
      return exports.warn('RC4 is not safe; please use a safer cipher, like AES-256-CFB');
    }
  };

  exports.version = "" + pack.name + " v" + pack.version;

  exports.EVERYTHING = 0;

  exports.DEBUG = 1;

  exports.INFO = 2;

  exports.WARN = 3;

  exports.ERROR = 4;

  _logging_level = exports.INFO;

  exports.config = function(level) {
    return _logging_level = level;
  };

  exports.log = function(level, msg) {
    if (level >= _logging_level) {
      if (level >= exports.DEBUG) {
        return util.log(new Date().getMilliseconds() + 'ms ' + msg);
      } else {
        return util.log(msg);
      }
    }
  };

  exports.debug = function(msg) {
    return exports.log(exports.DEBUG, msg);
  };

  exports.info = function(msg) {
    return exports.log(exports.INFO, msg);
  };

  exports.warn = function(msg) {
    return exports.log(exports.WARN, msg);
  };

  exports.error = function(msg) {
    return exports.log(exports.ERROR, (msg != null ? msg.stack : void 0) || msg);
  };

  exports.inetNtoa = function(buf) {
    return buf[0] + "." + buf[1] + "." + buf[2] + "." + buf[3];
  };

  exports.inetAton = function(ipStr) {
    var buf, i, parts;
    parts = ipStr.split(".");
    if (parts.length !== 4) {
      return null;
    } else {
      buf = new Buffer(4);
      i = 0;
      while (i < 4) {
        buf[i] = +parts[i];
        i++;
      }
      return buf;
    }
  };

  setInterval(function() {
    var cwd, e, heapdump;
    if (_logging_level <= exports.DEBUG) {
      exports.debug(JSON.stringify(process.memoryUsage(), ' ', 2));
      if (global.gc) {
        exports.debug('GC');
        gc();
        exports.debug(JSON.stringify(process.memoryUsage(), ' ', 2));
        cwd = process.cwd();
        if (_logging_level === exports.DEBUG) {
          try {
            heapdump = require('heapdump');
            process.chdir('/tmp');
            return process.chdir(cwd);
          } catch (_error) {
            e = _error;
            return exports.debug(e);
          }
        }
      }
    }
  }, 1000);

}).call(this);
