import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import java.io.File;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Node;
import org.w3c.dom.NamedNodeMap;

import org.apache.log4j.*;

public class OrderProcessor {
	static Logger logger = Logger.getLogger(OrderProcessor.class);
	static int curLvl=0;
   	public static void main (String args[]) {
   		//orders.xmlһxmlļ
      File docFile = new File("orders.xml");
      Document doc = null;  
        //log4jļ
      PropertyConfigurator.configure("log4j.inf");
      try {
		DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
		dbf.setValidating(false);
        DocumentBuilder db = dbf.newDocumentBuilder();
        
        logger.info("ȡDocument");
        doc = db.parse(docFile);
		
		logger.info("ȡroot");
		Element root = doc.getDocumentElement();
      	System.out.println("The root element is " + root.getNodeName());
		
		logger.info("ȡrootӽ");
		NodeList children = root.getChildNodes();
   		System.out.println("There are "+children.getLength()+" nodes in this document.");
		
		logger.info("rootֱӽ");
		int i=0;
		for (Node child = root.getFirstChild(); child != null; child = child.getNextSibling()) {
			i++;
			System.out.println(i);
         	System.out.println(child.getNodeName()+" = "+child.getNodeValue());   
      	}
      	
      	logger.info("ʾԱ");
		stepThrough(root,false);      	
      	logger.info("ʾԱ");
		stepThrough(root,true);      	

		logger.info("ʾ'status'.");
		listCol(root, "status");
		logger.info("statusеֵprocessing");
		changeOrder(root, "status", "processing");
		logger.info("ʾ޸ĺ'status'");
		listCol(root, "status");
		
		logger.info("ÿorderһtotalԪ");
		addTotalElem(root,doc);
		logger.info("ʾԱ");
		stepThrough(root,true);      	

		logger.info("ɲһ.");
		outputRes(db,doc);
	  } catch (javax.xml.parsers.ParserConfigurationException pce) {
         logger.error("The parser was not configured correctly.");
         System.exit(1);
      } catch (java.io.IOException ie) {
         logger.error("Cannot read input file.");
         System.exit(1);
      } catch (org.xml.sax.SAXException se) {
         logger.error("Problem parsing the file.");
         System.exit(1);
      } catch (java.lang.IllegalArgumentException ae) {
         logger.error("Please specify an XML source.");
         System.exit(1);
							
      }
	}
	private static void changeOrder (Node start, String elemName,  String elemValue){
      	if (start.getNodeName().equals(elemName)) {
      		System.out.println("the value of '"+elemName+"' is alter from ["+start.getFirstChild().getNodeValue()+"] to ["+elemValue+"]");
         	start.getFirstChild().setNodeValue(elemValue);
      	}
         
      	for (Node child = start.getFirstChild(); child != null; child = child.getNextSibling()){
          	changeOrder(child, elemName, elemValue);
      	}
   	}
   	private static void listCol (Element start, String elemName){
      	NodeList orders = start.getElementsByTagName(elemName);
      	for (int orderNum = 0; orderNum < orders.getLength();  orderNum++) {
          	System.out.println(orders.item(orderNum).getFirstChild().getNodeValue());
     	}
	}
   	private static void stepThrough (Node start,boolean showAttr){
   		curLvl++;
      	logger.info(showBlanks(curLvl)+start.getNodeName()+" = "+start.getNodeValue());   
      	if(showAttr){
			if (start.getNodeType() == start.ELEMENT_NODE) {   
          		NamedNodeMap startAttr = start.getAttributes();
          		for (int i = 0; i < startAttr.getLength(); i++) {
             		Node attr = startAttr.item(i);
             		showBlanks(curLvl);
             		logger.info(showBlanks(curLvl)+"[ Attribute:  "+ attr.getNodeName() +" = "+attr.getNodeValue()+"]");
          		}   
      		} 
      	}
      	for (Node child = start.getFirstChild(); child != null; child = child.getNextSibling()){
	    	  stepThrough(child,showAttr);
      	}
      	curLvl--;
	}
	//ʾʱͬһԪ
	private static String showBlanks(int loops){
		String res="";
   		for (int i=0;i<loops;i++){
   			res=res+"    ";
   		}
   		return res;
	}
	private static void addTotalElem(Element root,Document doc){
		NodeList orders = root.getElementsByTagName("order");
		
		for (int orderNum = 0; orderNum < orders.getLength(); orderNum++) {
		   	Element thisOrder = (Element)orders.item(orderNum);
   			NodeList orderItems = thisOrder.getElementsByTagName("item");
   			
   			double total = 0;
   			for (int itemNum = 0; itemNum < orderItems.getLength();  itemNum++) {
					
    		  // Total up cost for each item and 
    		  // add to the order total
					  
    		    //Get this item as an Element
    		    Element thisOrderItem = (Element)orderItems.item(itemNum);
				if (thisOrderItem.getAttributeNode("instock").getNodeValue().equals("N")) {
					Element backElement = doc.createElement("backordered");
					backElement.setAttributeNode(doc.createAttribute("itemid"));
				   
   					String itemIdString = thisOrderItem.getAttributeNode("itemid").getNodeValue();
   					backElement.setAttribute("itemid", itemIdString);
						
      				Node deadNode = thisOrderItem.getParentNode().replaceChild(	backElement, thisOrderItem);

      				
			    } else {
    		
    		    //Get pricing information for this Item
    		    String thisPrice = thisOrderItem.getElementsByTagName("price").item(0).getFirstChild().getNodeValue();
    		    double thisPriceDbl = new Double(thisPrice).doubleValue();
						
    		    //Get quantity information for this Item
    		    String thisQty = thisOrderItem.getElementsByTagName("qty").item(0).getFirstChild().getNodeValue();
    		    double thisQtyDbl = new Double(thisQty).doubleValue();
    		
    		    double thisItemTotal = thisPriceDbl*thisQtyDbl;
    		    total = total + thisItemTotal;
    		    }
    		}
    		String totalString = new Double(total).toString();
			
			Node totalNode = doc.createTextNode(totalString);
    		Element totalElement = doc.createElement("total");
    		totalElement.appendChild(totalNode);
	   		thisOrder.insertBefore(totalElement, thisOrder.getFirstChild());
//			Element customer = (Element)thisOrder.getElementsByTagName("cusomertid").item(0);
//			customer.removeAttribute("limit");		  

	   		
		}
	}
	private static void outputRes(DocumentBuilder db,Document doc){
		Document newdoc = db.newDocument();
		Element newRoot = newdoc.createElement("processedOrders");

		NodeList processOrders = doc.getElementsByTagName("order");
		for (int orderNum = 0;orderNum < processOrders.getLength(); orderNum++) {

		   Element thisOrder = (Element)processOrders.item(orderNum);		  

		   Element customerid = (Element)thisOrder.getElementsByTagName("customerid").item(0);

		   String limit = customerid.getAttributeNode("limit").getNodeValue();

		   String total = thisOrder.getElementsByTagName("total").item(0).getFirstChild().getNodeValue();

		   double limitDbl = new Double(limit).doubleValue();
		   double totalDbl = new Double(total).doubleValue();

		   Element newOrder = newdoc.createElement("order");

		   Element newStatus = newdoc.createElement("status");
		   if (totalDbl > limitDbl) {
		      newStatus.appendChild(newdoc.createTextNode("REJECTED"));
		   } else {
		      newStatus.appendChild(newdoc.createTextNode("PROCESSED"));
		   }

		   Element newCustomer = newdoc.createElement("customerid");
		   String oldCustomer = customerid.getFirstChild().getNodeValue();
		   newCustomer.appendChild(newdoc.createTextNode(oldCustomer));

		   Element newTotal = newdoc.createElement("total");
		   newTotal.appendChild(newdoc.createTextNode(total));

		   newOrder.appendChild(newStatus);
		   newOrder.appendChild(newCustomer);
		   newOrder.appendChild(newTotal);

		   newRoot.appendChild(newOrder);
		}

		newdoc.appendChild(newRoot);
		newRoot=newdoc.getDocumentElement();
		newRoot.normalize();
		System.out.println("-----------------------------------------------");
		System.out.println(newRoot.toString());  //󲻺ʹ
		stepThrough(newRoot,true);
	}
}
