import org.xml.sax.helpers.DefaultHandler;
import org.apache.log4j.*;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.XMLReader;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import org.xml.sax.SAXException;
import org.xml.sax.Attributes;

public class SurveyReader extends DefaultHandler
{

	static Logger logger = Logger.getLogger(SurveyReader.class);
	static int curLvl=0;
   public SurveyReader() {
      logger.info("reader created");
   }

   public void showEvent(String name) {
      logger.info("Hello, "+name+"!");
   }
	public void error (SAXParseException e) {
      logger.error("Error parsing the file: "+e.getMessage());
   }

   public void warning (SAXParseException e) {
      logger.warn("Problem parsing the file: "+e.getMessage());
   }

   public void fatalError (SAXParseException e) {
      logger.error("Error parsing the file: "+e.getMessage());
      logger.error("Cannot continue.");
      System.exit(1);
   }
	public void processingInstruction(String target, String data)
	      throws SAXException {
		
	   logger.info("Target = ("+target+")");
	   logger.info("Data = ("+data+")");
	}
  	public void startDocument() throws SAXException {
      logger.info("Tallying survey results...");   
   	}
	public int getInstances (String all, String choice) {
		int count=0;
		int from=0;
		int slen=choice.length();
//		logger.info("string=["+all+"]ch=["+choice+"]");
		while ( (from=all.indexOf(choice,from))>-1 ){
				count = count + 1;
				from = from + slen;
		}
		return count;   	
	}
   
	public void endDocument() {
		
	   logger.info("Appearance of the aliens:");
	   showQuestionResult(appearance);
	   logger.info("Communicationg method:");
	   showQuestionResult(communication);
	   logger.info("Appearance of the ship:");
	   showQuestionResult(ship);
	   logger.info("Inside of the ship:");
	   showQuestionResult(inside);
	   logger.info("Implantation of device:");
	   showQuestionResult(implant);
	   
	}
	private void showQuestionResult(String qs){
		logger.info("A:  " + getInstances(qs, "A"));
		logger.info("B:  " + getInstances(qs, "B"));
		logger.info("C:  " + getInstances(qs, "C"));
		logger.info("D:  " + getInstances(qs, "D"));
	}
	public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {

       String eName=localName;
       if ("".equals(eName))eName=qName;
       logger.info("Start element: ");
       logger.info("     localName="+localName);
       logger.info("  namespaceURI="+namespaceURI);
       logger.info("         qName="+qName);
      

       if (atts!=null){
			for (int att = 0; att < atts.getLength();  att++) {
	       		String attName = atts.getLocalName(att);
	       		if("".equals(attName))attName=atts.getQName(att);
	//	       		logger.info("   " + attName + ": " + atts.getValue(attName));   
	   		} 
   		}
		if (eName == "response") {
  //    		logger.info("User: " + atts.getValue("username"));   
      	} else if (eName == "question") {
      		thisQuestion = atts.getValue("subject");
   		}
	  
   		thisElement = eName;

   }
	   
	public void endElement(String namespaceURI, String localName, String qName)throws SAXException {
   		//printIndent(indent);
   		String eName=localName;
   		if("".equals(localName))eName=qName;
//   		logger.info("End Element: "+eName);
   		thisQuestion = "";
		thisElement = "";

   		//indent = indent - 4;   
	}
	public void characters(char[] ch,int start,int length) throws SAXException  {
//		logger.info("start characters...");
//		logger.info(new String(ch,   start,  length));
		if (thisElement == "question") {
//      		printIndent(4);
//      		logger.info(thisQuestion + ": "+new String(ch,   start,  length));
   		}
		if (thisQuestion.equals("appearance")) {
		   appearance = appearance + new String(ch, start, length);
		}
		if (thisQuestion.equals("communication")) {
		   communication = communication + new String(ch, start, length);
		}
		if (thisQuestion.equals("ship")) {
		   ship = ship + new String(ch, start, length);
		}
		if (thisQuestion.equals("inside")) {
		   inside = inside + new String(ch, start, length);
		}
		if (thisQuestion.equals("implant")) {
		   implant = implant  + new String(ch, start, length);
		}

	}
	String thisQuestion = "";
	String thisElement = "";
	String appearance="";
	String communication="";
	String ship="";
	String inside="";
	String implant="";

   public static void main (String args[]) {
        //log4jļ
      PropertyConfigurator.configure("log4j.inf");
   
      SurveyReader reader = new SurveyReader();
      reader.showEvent("Nick");
      
	  XMLReader xmlReader = null;
      
      try {

        SAXParserFactory spfactory = SAXParserFactory.newInstance();
        spfactory.setValidating(false);
        SAXParser saxParser = spfactory.newSAXParser();
        xmlReader = saxParser.getXMLReader();
         
		xmlReader.setContentHandler(new SurveyReader());		 
		xmlReader.setErrorHandler(new SurveyReader());
		
		InputSource source = new InputSource("surveys.xml");
    	xmlReader.parse(source);		 

      } catch (Exception e) {
            logger.error(e);
            System.exit(1);
      }

   }

}

