/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoft.hxl.batch_package.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.jar.JarArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public final class WarUtils {
    private static final Logger logger = Logger.getLogger(WarUtils.class);

    private WarUtils() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void unZipWar(Path warFile, Path unZipPath) {
        logger.info("\u89e3\u538bWar\u6587\u4ef6\uff1a" + warFile);
        logger.info("\u89e3\u538b\u5230\u76ee\u6807\u8def\u5f84\uff1a" + unZipPath);
        logger.info("\u5f00\u59cb\u89e3\u538b\uff0c\u8bf7\u7a0d\u5019...");
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                BufferedInputStream bis = new BufferedInputStream(new FileInputStream(warFile.toFile()));
                try {
                    try (ArchiveInputStream ais = new ArchiveStreamFactory().createArchiveInputStream("jar", bis);){
                        JarArchiveEntry entry;
                        if (Files.exists(unZipPath, new LinkOption[0])) {
                            Files.delete(unZipPath);
                        }
                        Files.createDirectories(unZipPath, new FileAttribute[0]);
                        while ((entry = (JarArchiveEntry)ais.getNextEntry()) != null) {
                            Path currentPath;
                            if (entry.isDirectory()) {
                                currentPath = Paths.get(unZipPath.toString(), entry.getName());
                                if (!Files.exists(currentPath.getParent(), new LinkOption[0])) {
                                    Files.createDirectories(currentPath, new FileAttribute[0]);
                                    continue;
                                }
                                if (Files.exists(currentPath, new LinkOption[0])) continue;
                                Files.createDirectory(currentPath, new FileAttribute[0]);
                                continue;
                            }
                            currentPath = unZipPath.resolve(entry.getName());
                            if (!Files.exists(currentPath.getParent(), new LinkOption[0])) {
                                Files.createDirectories(currentPath.getParent(), new FileAttribute[0]);
                            }
                            Throwable throwable2 = null;
                            Object var9_14 = null;
                            try (OutputStream os = Files.newOutputStream(currentPath, new OpenOption[0]);){
                                IOUtils.copy(ais, os);
                            }
                            catch (Throwable throwable3) {
                                if (throwable2 == null) {
                                    throwable2 = throwable3;
                                    throw throwable2;
                                } else {
                                    if (throwable2 == throwable3) throw throwable2;
                                    throwable2.addSuppressed(throwable3);
                                }
                                throw throwable2;
                            }
                        }
                        logger.info("\u6210\u529f\u89e3\u538b\u5230\uff1a" + unZipPath.toString());
                    }
                    if (bis == null) return;
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    if (bis == null) throw throwable;
                    bis.close();
                    throw throwable;
                }
                bis.close();
                return;
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                    throw throwable;
                } else {
                    if (throwable == throwable5) throw throwable;
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        catch (IOException | ArchiveException e) {
            logger.error("War\u6587\u4ef6\u89e3\u538b\u5931\u8d25");
            throw new RuntimeException("War\u6587\u4ef6\u89e3\u538b\u5931\u8d25\u3002", e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void zipWar(Path sourceDir, Path distFile) {
        sourceDir = sourceDir.toAbsolutePath();
        String rootDir = sourceDir.toString();
        logger.info("------------------------------------------------------------");
        logger.info("\u9700\u8981\u6253\u5305\u6587\u4ef6\u6240\u5728\u76ee\u5f55\uff1a" + rootDir);
        logger.info("\u9700\u8981\u521b\u5efa\u7684War\u6587\u4ef6\uff1a" + distFile);
        logger.info("\u5f00\u59cb\u521b\u5efa\uff0c\u8bf7\u7a0d\u5019...");
        if (!rootDir.endsWith(File.separator)) {
            rootDir = String.valueOf(rootDir) + File.separator;
        }
        try {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try {
                    BufferedOutputStream bos = new BufferedOutputStream(Files.newOutputStream(distFile, new OpenOption[0]));
                    try {
                        try (ArchiveOutputStream aos = new ArchiveStreamFactory().createArchiveOutputStream("jar", bos);){
                            Iterator<File> files = FileUtils.iterateFiles(sourceDir.toFile(), null, true);
                            while (files.hasNext()) {
                                File file = files.next();
                                ZipArchiveEntry entry = new ZipArchiveEntry(file, StringUtils.remove(file.getAbsolutePath(), rootDir));
                                aos.putArchiveEntry(entry);
                                Throwable throwable2 = null;
                                Object var11_16 = null;
                                try (FileInputStream is = new FileInputStream(file);){
                                    IOUtils.copy(is, aos);
                                }
                                catch (Throwable throwable3) {
                                    if (throwable2 == null) {
                                        throwable2 = throwable3;
                                        throw throwable2;
                                    } else {
                                        if (throwable2 == throwable3) throw throwable2;
                                        throwable2.addSuppressed(throwable3);
                                    }
                                    throw throwable2;
                                }
                                aos.closeArchiveEntry();
                            }
                            aos.flush();
                            logger.info("\u6210\u529f\u521b\u5efaWar\u6587\u4ef6\uff1a" + distFile);
                        }
                        if (bos == null) return;
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                        } else if (throwable != throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        if (bos == null) throw throwable;
                        bos.close();
                        throw throwable;
                    }
                    bos.close();
                    return;
                }
                catch (Throwable throwable5) {
                    if (throwable == null) {
                        throwable = throwable5;
                        throw throwable;
                    } else {
                        if (throwable == throwable5) throw throwable;
                        throwable.addSuppressed(throwable5);
                    }
                    throw throwable;
                }
            }
            catch (IOException | ArchiveException e) {
                logger.error("War\u6587\u4ef6\u521b\u5efa\u5931\u8d25");
                throw new RuntimeException("War\u6587\u4ef6\u521b\u5efa\u5931\u8d25\u3002", e);
            }
        }
        finally {
            logger.info("------------------------------------------------------------");
        }
    }
}

