/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoft.hxl.batch_package.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;

public final class TxtUtils {
    private static final String CHARACTER_ENCODING = "utf-8";

    private TxtUtils() {
    }

    public static List<String> readTxt(File txtFile) throws IOException {
        ArrayList<String> linesData = new ArrayList<String>();
        if (txtFile.exists()) {
            String line;
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(txtFile), CHARACTER_ENCODING);
            BufferedReader br = new BufferedReader(reader);
            while ((line = br.readLine()) != null) {
                linesData.add(line);
            }
            br.close();
            RandomAccessFile raf = new RandomAccessFile(txtFile, "r");
            raf.seek(raf.length() - 1L);
            line = raf.readLine();
            raf.close();
            if (line.length() == 0) {
                linesData.add("");
            }
        }
        return linesData;
    }

    public static void writeTxt(List<String> list, File txtFile) throws IOException {
        if (list == null) {
            return;
        }
        Path newFilePath = Paths.get(txtFile.toURI());
        Files.deleteIfExists(newFilePath);
        Files.createFile(newFilePath, new FileAttribute[0]);
        StringBuilder txtBuilder = new StringBuilder(80);
        for (String str : list) {
            txtBuilder.append(str).append("\r\n");
        }
        txtBuilder.delete(txtBuilder.length() - 2, txtBuilder.length());
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(txtFile), CHARACTER_ENCODING));
        out.write(txtBuilder.toString());
        ((Writer)out).flush();
        ((Writer)out).close();
    }
}

