/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoft.hxl.batch_package.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.sinosoft.hxl.batch_package.bean.ConfigItem;
import com.sinosoft.hxl.batch_package.bean.MainConfig;
import com.sinosoft.hxl.batch_package.bean.Strategy;
import com.sinosoft.hxl.batch_package.utils.Const;
import com.sinosoft.hxl.batch_package.utils.TxtUtils;
import com.sinosoft.hxl.batch_package.utils.WarUtils;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public enum CoreService {
    INSTANCE;

    private static final Logger logger;

    static {
        logger = Logger.getLogger(CoreService.class);
    }

    private List<ConfigItem> getValidConfigItems(MainConfig mainConfig) {
        Strategy strategy = mainConfig.getStrategy();
        String activeStrategy = mainConfig.getStrategy().getActive();
        List<ConfigItem> configItems = mainConfig.getConfiguration();
        if ("include".equals(activeStrategy)) {
            logger.info("\u5f53\u524d\u4f7f\u7528\u7684\u751f\u6210\u7b56\u7565\uff1ainclude");
            String includes = "|" + strategy.getInclude() + "|";
            Iterator<ConfigItem> iterator = configItems.iterator();
            while (iterator.hasNext()) {
                ConfigItem configItem = iterator.next();
                String folder = configItem.getGenerateFolder();
                if (includes.contains("|" + folder + "|")) continue;
                logger.info("\u6392\u9664\u914d\u7f6e\u8282\u70b9\uff1a" + folder);
                iterator.remove();
            }
            return configItems;
        }
        if ("exclude".equals(activeStrategy)) {
            logger.info("\u5f53\u524d\u4f7f\u7528\u7684\u751f\u6210\u7b56\u7565\uff1aexclude");
            String excludes = "|" + strategy.getExclude() + "|";
            Iterator<ConfigItem> iterator = configItems.iterator();
            while (iterator.hasNext()) {
                ConfigItem configItem = iterator.next();
                String folder = configItem.getGenerateFolder();
                if (!excludes.contains("|" + folder + "|")) continue;
                logger.info("\u6392\u9664\u914d\u7f6e\u8282\u70b9\uff1a" + folder);
                iterator.remove();
            }
            return configItems;
        }
        if (!"default".equals(activeStrategy)) {
            logger.warn("\u6838\u5fc3\u914d\u7f6e strategy -> active \u5e94\u4e3a default\u3001include\u6216exclude\uff0c\u5f53\u524d\u914d\u7f6e\u4e3a\uff1a" + activeStrategy + "\uff0c\u914d\u7f6e\u65e0\u6548\uff0c\u5df2\u4f7f\u7528default\u914d\u7f6e");
        }
        logger.info("\u5f53\u524d\u4f7f\u7528\u7684\u751f\u6210\u7b56\u7565\uff1adefault");
        return configItems;
    }

    private Map<Path, Path> backup(List<ConfigItem> configItems) throws Exception {
        logger.info("\u5f00\u59cb\u626b\u63cf\u5f85\u5904\u7406\u6587\u4ef6\uff0c\u8bf7\u7a0d\u5019...");
        HashMap<Path, Path> confFileInfo = new HashMap<Path, Path>();
        for (ConfigItem configItem : configItems) {
            for (JSONObject item : configItem.getItems()) {
                String relativeFileName;
                URL confFileUrl;
                String configFileName = item.getString("configFileName");
                if (!configFileName.startsWith("/") && !configFileName.startsWith("\\")) {
                    configFileName = String.valueOf(File.separator) + configFileName;
                }
                if ((confFileUrl = ClassLoader.getSystemResource(relativeFileName = "_tmp" + configFileName)) == null) {
                    logger.warn("\u6307\u5b9a\u7684\u5f85\u5904\u7406\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a" + configFileName);
                    continue;
                }
                logger.info("\u53d1\u73b0\u5f85\u5904\u7406\u6587\u4ef6\uff1a" + configFileName);
                URI configFileUri = confFileUrl.toURI();
                Path confFilePath = Paths.get(configFileUri);
                File targetFile = new File(String.valueOf(Const.WORK_DIRECTORY) + "_bak" + configFileName);
                confFileInfo.put(confFilePath, Paths.get(targetFile.toURI()));
            }
        }
        if (confFileInfo.isEmpty()) {
            logger.info("\u6839\u636e\u4f60\u7684\u914d\u7f6e\uff0c\u4e8c\u6b21\u6253\u5305\u65f6\uff0c\u6ca1\u6709\u9700\u8981\u4fee\u6539\u7684\u5f85\u5904\u7406\u5f85\u5904\u7406\u6587\u4ef6");
        } else {
            logger.info("\u6839\u636e\u4f60\u7684\u914d\u7f6e\uff0c\u5171\u53d1\u73b0 " + confFileInfo.size() + " \u4efd\u5f85\u5904\u7406\u6587\u4ef6");
            logger.info("\u5f00\u59cb\u5907\u4efd\u5f85\u5904\u7406\u6587\u4ef6...");
            for (Map.Entry entry : confFileInfo.entrySet()) {
                Path targetDirectory = ((Path)entry.getValue()).getParent();
                if (!Files.exists(targetDirectory, new LinkOption[0])) {
                    Files.createDirectories(targetDirectory, new FileAttribute[0]);
                }
                logger.info("\u4ece\u6e90\uff1a" + entry.getKey());
                logger.info("\u590d\u5236\u5230\uff1a" + entry.getValue());
                Files.copy((Path)entry.getKey(), (Path)entry.getValue(), new CopyOption[0]);
            }
        }
        return confFileInfo;
    }

    private boolean parser(ConfigItem configItem) throws IOException {
        String node = configItem.getGenerateFolder();
        List<JSONObject> items = configItem.getItems();
        for (JSONObject item : items) {
            int index;
            File file;
            String configFileName = item.getString("configFileName");
            if (!configFileName.startsWith("/") && !configFileName.startsWith("\\")) {
                configFileName = String.valueOf(File.separator) + configFileName;
            }
            if (!(file = new File(String.valueOf(Const.WORK_DIRECTORY) + "_tmp" + configFileName)).exists()) continue;
            TreeMap<Integer, String> rowInfo = new TreeMap<Integer, String>();
            for (String keyName : item.keySet()) {
                if ("configFileName".equals(keyName)) continue;
                String[] rows = keyName.split("-");
                if (rows.length == 1) {
                    int row = Integer.valueOf(keyName.trim());
                    rowInfo.put(row, item.getString(keyName));
                    continue;
                }
                if (rows.length == 2) {
                    int startRow = Integer.valueOf(rows[0].trim());
                    int endRow = Integer.valueOf(rows[1].trim());
                    if (startRow <= 0 || endRow <= 0 || startRow > endRow) {
                        logger.warn("\u6838\u5fc3\u914d\u7f6e configuration -> " + node + " \u5b58\u5728\u9519\u8bef\u7684\u952e\u503c\uff1a" + keyName);
                        return false;
                    }
                    Object obj = item.get(keyName);
                    if (obj instanceof String) {
                        if (startRow != endRow) {
                            logger.info("\u6838\u5fc3\u914d\u7f6e configuration -> " + node + " \u4e2d\u5b58\u5728\u914d\u7f6e\u9879\uff1a" + keyName + "\uff0c\u591a\u884c\u5143\u7d20\u5c06\u88ab\u6539\u79f0\u540c\u4e00\u4e2a\u503c\uff1a" + obj);
                        }
                        int index2 = startRow;
                        while (index2 <= endRow) {
                            rowInfo.put(index2, item.getString(keyName));
                            ++index2;
                        }
                        continue;
                    }
                    if (obj instanceof JSONArray) {
                        int index3;
                        int statementRow = endRow - startRow + 1;
                        JSONArray multiContent = (JSONArray)obj;
                        int realRow = multiContent.size();
                        if (statementRow <= realRow) {
                            if (statementRow < realRow) {
                                logger.warn("\u6838\u5fc3\u914d\u7f6e configuration -> " + node + " \u4e2d\u5b58\u5728\u914d\u7f6e\u9879\uff1a" + keyName + " \u5e94\u8be5\u5305\u542b " + statementRow + " \u4e2a\u5b50\u5143\u7d20\uff0c\u5b9e\u9645\u914d\u7f6e\u4e86 " + realRow + " \u4e2a\u5b50\u5143\u7d20\uff0c\u591a\u4f59\u7684\u5b50\u5143\u7d20\u5df2\u7ecf\u88ab\u5ffd\u7565");
                            }
                            index3 = startRow;
                            while (index3 <= endRow) {
                                rowInfo.put(index3, multiContent.getString(index3 - startRow));
                                ++index3;
                            }
                            continue;
                        }
                        logger.warn("\u6838\u5fc3\u914d\u7f6e configuration -> " + node + " \u4e2d\u5b58\u5728\u914d\u7f6e\u9879\uff1a" + keyName + " \u5e94\u8be5\u5305\u542b " + statementRow + " \u4e2a\u5b50\u5143\u7d20\uff0c\u5b9e\u9645\u914d\u7f6e\u4e86 " + realRow + " \u4e2a\u5b50\u5143\u7d20\uff0c\u7f3a\u5c11\u7684\u914d\u7f6e\u5c06\u4f1a\u88ab\u5ffd\u7565");
                        index3 = startRow;
                        while (index3 < startRow + realRow) {
                            rowInfo.put(index3, multiContent.getString(index3 - startRow));
                            ++index3;
                        }
                        continue;
                    }
                    logger.error("\u6838\u5fc3\u914d\u7f6e configuration -> " + node + " \u5b58\u5728\u9519\u8bef\u7684\u952e\u503c\uff1a" + keyName + "\uff0c\u8be5\u914d\u7f6e\u53ea\u80fd\u662fString\u6216JSONArray");
                    return false;
                }
                logger.error("\u6838\u5fc3\u914d\u7f6e configuration -> " + node + " \u5b58\u5728\u9519\u8bef\u7684\u952e\u503c\uff1a" + keyName);
                return false;
            }
            List<String> txtRows = TxtUtils.readTxt(file);
            Integer startRow = (Integer)rowInfo.firstKey();
            Integer endRow = (Integer)rowInfo.lastKey();
            if (endRow <= txtRows.size()) {
                index = startRow;
                while (index <= endRow) {
                    if (rowInfo.keySet().contains(index)) {
                        txtRows.set(index - 1, (String)rowInfo.get(index));
                    }
                    ++index;
                }
            } else {
                logger.warn(String.valueOf(node) + " -> " + configFileName + " \u6587\u4ef6\u9700\u8981\u4fee\u6539\u7684\u6700\u5927\u884c\u6570\u5927\u4e8e\u6587\u672c\u603b\u884c\u6570\uff0c\u672a\u6307\u5b9a\u7684\u884c\u5c06\u4f7f\u7528\u7a7a\u884c\u586b\u5145");
                if (startRow <= txtRows.size()) {
                    index = startRow;
                    while (index <= txtRows.size()) {
                        if (rowInfo.keySet().contains(index)) {
                            txtRows.set(index - 1, (String)rowInfo.get(index));
                        }
                        ++index;
                    }
                }
                index = txtRows.size();
                while (index < endRow) {
                    if (rowInfo.keySet().contains(index + 1)) {
                        txtRows.add((String)rowInfo.get(index + 1));
                    } else {
                        txtRows.add("");
                    }
                    ++index;
                }
            }
            TxtUtils.writeTxt(txtRows, file);
        }
        return true;
    }

    private void generate(List<ConfigItem> configItems, Map<Path, Path> backupInfo, String warFileName) throws Exception {
        for (ConfigItem configItem : configItems) {
            String generateFolder = configItem.getGenerateFolder();
            if (StringUtils.isBlank(generateFolder)) {
                logger.warn("\u6838\u5fc3\u914d\u7f6e configuration -> generateFolder \u5fc5\u987b\u914d\u7f6e\uff0c\u5e76\u4e14\u914d\u7f6e\u503c\u4e0d\u80fd\u4e3a\u7a7a\u683c\u3001\u7a7a\u5b57\u7b26\u4e32\u7b49\u7279\u6b8a\u5b57\u7b26\uff0c\u5efa\u8bae\u4f7f\u7528\u82f1\u6587\u5b57\u6bcd\u3001\u6570\u5b57");
                continue;
            }
            File generateDirectory = new File(String.valueOf(Const.WORK_DIRECTORY) + "_gen" + File.separator + generateFolder);
            if (generateDirectory.exists()) {
                logger.warn("\u6838\u5fc3\u914d\u7f6e configuration -> generateFolder \u51fa\u73b0\u91cd\u590d\u7684\u503c\uff1a" + generateFolder + "\uff0c\u5df2\u4f7f\u7528\u7b2c\u4e00\u4e2a\u8282\u70b9\u7684\u914d\u7f6e\uff0c\u5176\u4ed6\u91cd\u590d\u914d\u7f6e\u5c06\u4f1a\u88ab\u5ffd\u7565");
                continue;
            }
            Files.createDirectories(Paths.get(generateDirectory.toURI()), new FileAttribute[0]);
            if (!this.parser(configItem)) continue;
            URI sourceUri = ClassLoader.getSystemResource("_tmp").toURI();
            URI generateUri = new File(generateDirectory, warFileName).toURI();
            logger.info("\u5f00\u59cb\u751f\u6210War\u6587\u4ef6\uff0c\u4f7f\u7528\u914d\u7f6e\u8282\u70b9\uff1a" + generateFolder);
            WarUtils.zipWar(Paths.get(sourceUri), Paths.get(generateUri));
            for (Map.Entry<Path, Path> entry : backupInfo.entrySet()) {
                Files.deleteIfExists(entry.getKey());
                Files.copy(entry.getValue(), entry.getKey(), new CopyOption[0]);
            }
        }
    }

    public void work(MainConfig mainConfig) throws Exception {
        List<ConfigItem> configItems = this.getValidConfigItems(mainConfig);
        Map<Path, Path> backupInfo = this.backup(configItems);
        this.generate(configItems, backupInfo, mainConfig.getWarFileName());
    }
}

