//
//  KIFTestScenario+EXAdditions.m
//  HelloWorld
//
//  Created by twer on 4/24/12.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#import "KIFTestScenario+EXAdditions.h"
#import "KIFTestStep.h"
#import "KIFTestStep+EXAdditions.h"

@implementation KIFTestScenario (EXAdditions)

+ (id)scenarioDefaultValue;
{
    //expect to fail if the order of scenario is not set
    KIFTestScenario *scenario = [KIFTestScenario scenarioWithDescription:@"Test welcome message with default value"];
    [scenario addStep:[KIFTestStep stepToTapViewWithAccessibilityLabel:@"button"]];
    
    // Verify value of both textField and label
    [scenario addStep:[KIFTestStep stepToWaitForViewWithAccessibilityLabel:@"display" value:@"Hello, Your Name!" traits:UIAccessibilityTraitNone]];
    [scenario addStep:[KIFTestStep stepToWaitForViewWithAccessibilityLabel:@"label" value:@"Hello, Your Name!" traits:UIAccessibilityTraitNone]];
    
    return scenario;
}

+ (id)scenarioCustomizedValue;
{
    return [self scenarioDefault:@"Test welcome message with customized value" input:@"testName" expect:@"Hello, testName!"];
}

+ (id)scenarioEmptyValue;
{
    return [self scenarioDefault:@"Test welcome message with empty value" input:@"" expect:@"Hello, World!"];
}

+ (id)scenarioDefault:(NSString *)scenarioTitle input:(NSString *)input expect:(NSString *)expect;
{
    KIFTestScenario *scenario = [KIFTestScenario scenarioWithDescription:scenarioTitle];
    [scenario addStep:[KIFTestStep stepToEnterText:input intoViewWithAccessibilityLabel:@"input"]];
    [scenario addStep:[KIFTestStep stepToTapViewWithAccessibilityLabel:@"button"]];
    
    // Verify value of both textField and label
    [scenario addStep:[KIFTestStep stepToWaitForViewWithAccessibilityLabel:@"display" value:expect traits:UIAccessibilityTraitNone]];
    [scenario addStep:[KIFTestStep stepToWaitForViewWithAccessibilityLabel:@"label" value:expect traits:UIAccessibilityTraitNone]];
    
    return scenario;
}

@end