package com.calculator.test;

import java.io.File;
import com.google.android.testing.nativedriver.client.AdbConnectionBuilder;
import com.google.android.testing.nativedriver.client.AndroidNativeDriver;
import com.google.android.testing.nativedriver.client.AndroidNativeDriverBuilder;
import junit.framework.TestCase;
import org.openqa.selenium.By;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.WebElement;

public class NativeDriverAndroidTests extends TestCase {
	private AndroidNativeDriver driver;

	@Override
	protected void setUp() {
		driver = getDriver();
	}

	@Override
	protected void tearDown() {
		driver.quit();
	}

	protected AndroidNativeDriver getDriver() {
		return new AndroidNativeDriverBuilder().withDefaultServer().withAdbConnection(new AdbConnectionBuilder()
        .findAdbFromAndroidSdk("/Applications/eclipse/Android-SDK/")
        .build()).build();
	}

	private void startMainActivity() {
		driver.startActivity("com.calculator.Main");
	}

	private void inputText(String textFieldId, String value) {
		WebElement textField = driver.findElement(By.id(textFieldId));
		textField.clear();
		textField.click();
		textField.sendKeys(value);
	}
	
	private void takeScreenshot(String fullPath) {
		File screenshot = driver.getScreenshotAs(OutputType.FILE); 
        screenshot.renameTo(new File(fullPath)); 
	}
	
	public void testMultiply() throws Exception {
		startMainActivity();

		inputText("EditText01","10");
		inputText("EditText02","2");
		
		driver.navigate().back();
		WebElement button = driver.findElement(By.id("Button01"));
		button.click();
		//driver.findElement(AndroidNativeBy.text("Multiply")).click();
		
		Thread.sleep(3000);
		
		takeScreenshot("/Users/twer/Downloads/multiply.png");
		
		WebElement result = driver.findElement(By.id("TextView01"));

		assertEquals("20.0", result.getText());
	}

}