/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.android.robotium.solo;

import android.view.View;
import android.widget.TextView;
import com.jayway.android.robotium.solo.ActivityUtils;
import com.jayway.android.robotium.solo.RobotiumUtils;
import com.jayway.android.robotium.solo.Scroller;
import com.jayway.android.robotium.solo.Searcher;
import com.jayway.android.robotium.solo.Sleeper;
import com.jayway.android.robotium.solo.ViewFetcher;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import junit.framework.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Waiter {
    private final ActivityUtils activityUtils;
    private final ViewFetcher viewFetcher;
    private final int TIMEOUT = 20000;
    private final int SMALLTIMEOUT = 10000;
    private final int MINITIMEOUT = 300;
    private final Searcher searcher;
    private final Scroller scroller;
    private final Sleeper sleeper;
    private int numberOfUniqueViews;

    public Waiter(ActivityUtils activityUtils, ViewFetcher viewFetcher, Searcher searcher, Scroller scroller, Sleeper sleeper) {
        this.activityUtils = activityUtils;
        this.viewFetcher = viewFetcher;
        this.searcher = searcher;
        this.scroller = scroller;
        this.sleeper = sleeper;
    }

    public boolean waitForActivity(String name) {
        return this.waitForActivity(name, 10000);
    }

    public boolean waitForActivity(String name, int timeout) {
        long now = System.currentTimeMillis();
        long endTime = now + (long)timeout;
        while (!this.activityUtils.getCurrentActivity().getClass().getSimpleName().equals(name) && now < endTime) {
            now = System.currentTimeMillis();
        }
        return now < endTime;
    }

    public <T extends View> boolean waitForView(Class<T> viewClass, int index) {
        return this.waitForView(viewClass, index, 10000, true);
    }

    public <T extends View> boolean waitForView(Class<T> viewClass, int index, boolean scroll) {
        return this.waitForView(viewClass, index, 10000, scroll);
    }

    public <T extends View> boolean waitForView(Class<T> viewClass, int index, int timeout, boolean scroll) {
        ArrayList<Object> allViews = new ArrayList();
        HashSet uniqueViews = new HashSet();
        long endTime = System.currentTimeMillis() + (long)timeout;
        while (System.currentTimeMillis() < endTime) {
            this.sleeper.sleep();
            allViews = this.viewFetcher.getCurrentViews(viewClass);
            allViews = RobotiumUtils.removeInvisibleViews(allViews);
            int uniqueViewsFound = this.getNumberOfUniqueViews(uniqueViews, allViews);
            allViews = null;
            if (uniqueViewsFound > 0 && index < uniqueViewsFound) {
                return true;
            }
            if (index == 0 && uniqueViewsFound > 0) {
                return true;
            }
            if (!scroll) continue;
            this.scroller.scroll(0);
        }
        return false;
    }

    public <T extends View> boolean waitForViews(Class<T> viewClass, Class<? extends View> viewClass2) {
        long endTime = System.currentTimeMillis() + 10000L;
        while (System.currentTimeMillis() < endTime) {
            if (this.waitForView(viewClass, 0, 300, false)) {
                return true;
            }
            if (this.waitForView(viewClass2, 0, 300, false)) {
                return true;
            }
            this.scroller.scroll(0);
        }
        return false;
    }

    public boolean waitForView(View view) {
        return this.waitForView(view, 20000, true);
    }

    public boolean waitForView(View view, int timeout) {
        return this.waitForView(view, timeout, true);
    }

    public boolean waitForView(View view, int timeout, boolean scroll) {
        ArrayList<Object> views = new ArrayList();
        long startTime = System.currentTimeMillis();
        long endTime = startTime + (long)timeout;
        while (System.currentTimeMillis() <= endTime) {
            this.sleeper.sleep();
            views = this.viewFetcher.getAllViews(true);
            for (View view2 : views) {
                if (!view2.equals(view)) continue;
                return true;
            }
            if (!scroll) continue;
            this.scroller.scroll(0);
        }
        return false;
    }

    public View waitForView(int id) {
        ArrayList<Object> views = new ArrayList();
        long startTime = System.currentTimeMillis();
        long endTime = startTime + 10000L;
        while (System.currentTimeMillis() <= endTime) {
            views = this.viewFetcher.getAllViews(false);
            for (View view : views) {
                if (view.getId() != id) continue;
                return view;
            }
            this.sleeper.sleep();
        }
        return null;
    }

    public boolean waitForText(String text) {
        return this.waitForText(text, 0, 20000L, true);
    }

    public boolean waitForText(String text, int expectedMinimumNumberOfMatches) {
        return this.waitForText(text, expectedMinimumNumberOfMatches, 20000L, true);
    }

    public boolean waitForText(String text, int expectedMinimumNumberOfMatches, long timeout) {
        return this.waitForText(text, expectedMinimumNumberOfMatches, timeout, true);
    }

    public boolean waitForText(String text, int expectedMinimumNumberOfMatches, long timeout, boolean scroll) {
        return this.waitForText(text, expectedMinimumNumberOfMatches, timeout, scroll, false);
    }

    public boolean waitForText(String text, int expectedMinimumNumberOfMatches, long timeout, boolean scroll, boolean onlyVisible) {
        boolean foundAnyTextView;
        long endTime = System.currentTimeMillis() + timeout;
        do {
            boolean timedOut;
            boolean bl = timedOut = System.currentTimeMillis() > endTime;
            if (timedOut) {
                return false;
            }
            this.sleeper.sleep();
        } while (!(foundAnyTextView = this.searcher.searchFor(TextView.class, text, expectedMinimumNumberOfMatches, scroll, onlyVisible)));
        return true;
    }

    public <T extends View> T waitForAndGetView(int index, Class<T> classToFilterBy) {
        ArrayList<T> views;
        boolean found = this.waitForView(classToFilterBy, index);
        if (!found) {
            Assert.assertTrue((String)(classToFilterBy.getSimpleName() + " with index " + index + " is not available!"), (boolean)false);
        }
        if ((views = RobotiumUtils.removeInvisibleViews(this.viewFetcher.getCurrentViews(classToFilterBy))).size() < this.getNumberOfUniqueViews()) {
            index -= this.getNumberOfUniqueViews() - views.size();
        }
        View view = (View)views.get(index);
        return (T)view;
    }

    public <T extends View> int getNumberOfUniqueViews(Set<T> uniqueViews, ArrayList<T> views) {
        for (int i = 0; i < views.size(); ++i) {
            uniqueViews.add(views.get(i));
        }
        this.numberOfUniqueViews = uniqueViews.size();
        return this.numberOfUniqueViews;
    }

    public int getNumberOfUniqueViews() {
        return this.numberOfUniqueViews;
    }
}

