/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.android.robotium.solo;

import android.app.Activity;
import android.app.Instrumentation;
import android.content.IntentFilter;
import android.util.Log;
import com.jayway.android.robotium.solo.Sleeper;
import java.util.ArrayList;
import junit.framework.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ActivityUtils {
    private final Instrumentation inst;
    private Instrumentation.ActivityMonitor activityMonitor;
    private Activity activity;
    private final Sleeper sleeper;
    private ArrayList<Activity> activityList = new ArrayList();

    public ActivityUtils(Instrumentation inst, Activity activity, Sleeper sleeper) {
        this.inst = inst;
        this.activity = activity;
        this.sleeper = sleeper;
        this.setupActivityMonitor();
    }

    public ArrayList<Activity> getAllOpenedActivities() {
        return this.activityList;
    }

    private void setupActivityMonitor() {
        try {
            IntentFilter filter = null;
            this.activityMonitor = this.inst.addMonitor(filter, null, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Instrumentation.ActivityMonitor getActivityMonitor() {
        return this.activityMonitor;
    }

    public void setActivityOrientation(int orientation) {
        Activity activity = this.getCurrentActivity();
        activity.setRequestedOrientation(orientation);
    }

    public Activity getCurrentActivity() {
        return this.getCurrentActivity(true);
    }

    private final void waitForActivityIfNotAvailable() {
        if (this.activity == null) {
            if (this.activityMonitor != null) {
                while (this.activityMonitor.getLastActivity() == null) {
                    this.sleeper.sleepMini();
                }
            } else {
                this.sleeper.sleepMini();
                this.setupActivityMonitor();
                this.waitForActivityIfNotAvailable();
            }
        }
    }

    public Activity getCurrentActivity(boolean shouldSleepFirst) {
        if (shouldSleepFirst) {
            this.sleeper.sleep();
        }
        this.waitForActivityIfNotAvailable();
        Boolean found = false;
        if (this.activityMonitor != null && this.activityMonitor.getLastActivity() != null) {
            this.activity = this.activityMonitor.getLastActivity();
        }
        for (int i = 0; i < this.activityList.size(); ++i) {
            Activity storedActivity = this.activityList.get(i);
            if (!storedActivity.getClass().getName().equals(this.activity.getClass().getName())) continue;
            found = true;
        }
        if (found.booleanValue()) {
            return this.activity;
        }
        this.activityList.add(this.activity);
        return this.activity;
    }

    public void goBackToActivity(String name) {
        boolean found = false;
        for (Activity activity : this.activityList) {
            if (!activity.getClass().getSimpleName().equals(name)) continue;
            found = true;
        }
        if (found) {
            while (!this.getCurrentActivity().getClass().getSimpleName().equals(name)) {
                try {
                    this.inst.sendKeyDownUpSync(4);
                }
                catch (SecurityException e) {
                    Assert.assertTrue((String)("Activity named " + name + " can not be returned to"), (boolean)false);
                }
            }
        } else {
            for (int i = 0; i < this.activityList.size(); ++i) {
                Log.d((String)"Robotium", (String)("Activity priorly opened: " + this.activityList.get(i).getClass().getSimpleName()));
            }
            Assert.assertTrue((String)("No Activity named " + name + " has been priorly opened"), (boolean)false);
        }
    }

    public String getString(int resId) {
        Activity activity = this.getCurrentActivity(false);
        return activity.getString(resId);
    }

    public void finalize() throws Throwable {
        try {
            if (this.activityMonitor != null) {
                this.inst.removeMonitor(this.activityMonitor);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.finalize();
    }

    public void finishOpenedActivities() {
        for (int i = this.activityList.size() - 1; i >= 0; --i) {
            this.sleeper.sleep(100);
            this.activityList.get(i).finish();
        }
        this.getCurrentActivity().finish();
        this.sleeper.sleepMini();
        try {
            this.inst.sendKeyDownUpSync(4);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.activityList.clear();
    }
}

