package com.calculator.test;

import java.io.File;
import java.io.FileOutputStream;
import android.graphics.Bitmap;
import android.test.ActivityInstrumentationTestCase2;
import android.view.View;
import com.calculator.Main;
import com.jayway.android.robotium.solo.Solo;

public class RobotiumTests extends ActivityInstrumentationTestCase2<Main> {
	private Solo solo;

	public RobotiumTests() {
		super("com.calculator", Main.class);
	}

	@Override
	protected void setUp() throws Exception {
		super.setUp();
		solo = new Solo(getInstrumentation(), getActivity());
	}

	public void testMultiplyResult() {
		solo.enterText(0, "2");
		solo.enterText(1, "5");
		solo.clickOnButton("Multiply");
		assertTrue(solo.searchText("10"));
		try {
			takeScreenShot(solo.getViews().get(0), "test multiply result");
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	public static String SCREEN_SHOTS_LOCATION = "/sdcard/";

	public static void takeScreenShot(View view) throws Exception {
		takeScreenShot(view, "default");
	}

	public static void takeScreenShot(View view, String name) throws Exception {
		view.setDrawingCacheEnabled(true);
		view.buildDrawingCache();
		Bitmap b = view.getDrawingCache();
		FileOutputStream fos = null;
		try {
			File sddir = new File(SCREEN_SHOTS_LOCATION);
			if (!sddir.exists()) {
				sddir.mkdirs();
			}
			fos = new FileOutputStream(SCREEN_SHOTS_LOCATION + name + "_"
					+ System.currentTimeMillis() + ".jpg");
			if (fos != null) {
				b.compress(Bitmap.CompressFormat.JPEG, 90, fos);
				fos.close();
			}
		} catch (Exception e) {
		}
	}

	@Override
	protected void tearDown() throws Exception {
		solo.finishOpenedActivities();
	}
}