package com.calculator.test;

import android.test.ActivityInstrumentationTestCase2;
import com.jayway.android.robotium.solo.Solo;

@SuppressWarnings({ "unchecked", "rawtypes" })
public class RobotiumTests_APK extends ActivityInstrumentationTestCase2
{
    private static final String TARGET_PACKAGE_ID = "com.calculator";
    private static final String LAUNCHER_ACTIVITY_FULL_CLASSNAME = "com.calculator.Main";

    private static Class<?> launcherActivityClass;
    static{
            try {
                    launcherActivityClass = Class.forName(LAUNCHER_ACTIVITY_FULL_CLASSNAME);
            } catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
            }
    }
    
    public RobotiumTests_APK() throws ClassNotFoundException {
            super(TARGET_PACKAGE_ID, launcherActivityClass);
    }
    
    private Solo solo;

	@Override
	protected void setUp() throws Exception {
		super.setUp();
		solo = new Solo(getInstrumentation(), getActivity());
	}

	public void testMultiplyResult() {
		solo.enterText(0, "2");
		solo.enterText(1, "5");
		solo.clickOnButton("Multiply");
		assertTrue(solo.searchText("10"));
	}

	@Override
	protected void tearDown() throws Exception {

		solo.finishOpenedActivities();
	}
}