#import "tuneup/tuneup.js"
	var target = UIATarget.localTarget();
	var application = target.frontMostApp(); 
	var mainWindow = application.mainWindow();

	mainWindow.logElementTree();
	UIALogger.logStart("start log");

	var textField = mainWindow.textFields()[0];
	var label=mainWindow.staticTexts()[0];
	var button=mainWindow.buttons()[0];
	var displayField = mainWindow.textFields()["display"];

//tuneup_js
test("test default value", function(target, application) {
	button.tap();
	assertEquals(label.value(),"Hello, World!");
	target.captureScreenWithName("tuneup_js");
});

//test customized value
	textField.setValue("testName");
	button.tap();
	if (label.value()==("Hello, "+textField.value()+"!")) {
		UIALogger.logPass("Pass");
	} else {
		UIALogger.logFail("Fail: label='"+label.value()+"'");
	}
	target.captureScreenWithName("test customized value");

//test empty value
	textField.setValue("");
	button.tap();
	if (label.value()==("Hello, World!")) {
		UIALogger.logPass("Pass");
	} else {
		UIALogger.logFail("Fail: label='"+label.value()+"'");
	}
	target.captureScreenWithName("test empty value");