//
//  UIKitCatalogUITests.swift
//  UIKitCatalogUITests
//
//  Created by Yong Huang on 20/11/17.
//  Copyright © 2017 Apple. All rights reserved.
//

import XCTest

class UIKitCatalogUITests: XCTestCase {
        
    override func setUp() {
        super.setUp()
        
        // Put setup code here. This method is called before the invocation of each test method in the class.
        
        // In UI tests it is usually best to stop immediately when a failure occurs.
        continueAfterFailure = false
        // UI tests must launch the application that they test. Doing this in setup will make sure it happens for each test method.
        XCUIApplication().launch()

        // In UI tests it’s important to set the initial state - such as interface orientation - required for your tests before they run. The setUp method is a good place to do this.
    }
    
    override func tearDown() {
        // Put teardown code here. This method is called after the invocation of each test method in the class.
        super.tearDown()
    }
    
    func testExample() {
        
        let app = XCUIApplication()
        app.navigationBars["UIView"].buttons["UIKitCatalog"].tap()
        
        let tablesQuery = app.tables
        tablesQuery/*@START_MENU_TOKEN@*/.staticTexts["Text Fields"]/*[[".cells.staticTexts[\"Text Fields\"]",".staticTexts[\"Text Fields\"]"],[[[-1,1],[-1,0]]],[0]]@END_MENU_TOKEN@*/.tap()

        let cell = tablesQuery.children(matching: .cell).element(boundBy: 0)
        cell.textFields["Placeholder text"].tap()

        let textField = cell.children(matching: .textField).element
        textField.typeText("123")
        XCTAssert(textField.description.contains("123"))
        
        app.navigationBars["Text Fields"].buttons["UIKitCatalog"].tap()
        
        tablesQuery/*@START_MENU_TOKEN@*/.staticTexts["AlertControllerViewController"]/*[[".cells.staticTexts[\"AlertControllerViewController\"]",".staticTexts[\"AlertControllerViewController\"]"],[[[-1,1],[-1,0]]],[0]]@END_MENU_TOKEN@*/.tap()
        tablesQuery/*@START_MENU_TOKEN@*/.staticTexts["Simple"]/*[[".cells.staticTexts[\"Simple\"]",".staticTexts[\"Simple\"]"],[[[-1,1],[-1,0]]],[0]]@END_MENU_TOKEN@*/.tap()
        XCTAssert(app.alerts["A Short Title is Best"].buttons["OK"].exists)
        app.alerts["A Short Title is Best"].buttons["OK"].tap()
        
    }
    
}
