import os
import xbmc
import base64
import threading

from six.moves import urllib_request

from elementum.daemon import shutdown
from elementum.config import init, ELEMENTUMD_HOST, ONLY_CLIENT


class ElementumMonitor(xbmc.Monitor):
    def __init__(self):
        self._closing = threading.Event()

    @property
    def closing(self):
        return self._closing

    def onAbortRequested(self):
        # Only when closing Kodi
        if xbmc.abortRequested:
            xbmc.executebuiltin("Dialog.Close(all, true)")
            if not ONLY_CLIENT:
                shutdown()
            try:
                self._closing.set()
                self._closing.clear()
            except SystemExit as e:
                if e.code != 0:
                    os._exit(0)
                pass

    def onSettingsChanged(self):
        try:
            init()
            urllib_request.urlopen("%s/reload" % ELEMENTUMD_HOST)
            urllib_request.urlopen("%s/cmd/clear_page_cache" % ELEMENTUMD_HOST)
        except:
            pass

    def onNotification(self, sender, method, data):
        try:
            urllib_request.urlopen("%s/notification?sender=%s&method=%s&data=%s" % (
                ELEMENTUMD_HOST,
                sender,
                method,
                base64.b64encode(data)))
        except:
            pass
