from bonetorrent import plugin
from functools import wraps
import xbmc


TRACKING_ID = "UA-40799149-3"


def make_visitor():
    from pyga.requests import Visitor
    visitor = Visitor()
    visitor.user_agent = get_user_agent()
    visitor.locale = xbmc.getLanguage()
    return visitor


def get_ga():
    from pyga.requests import Tracker, Session, Config
    with plugin.get_storage("analytics") as ga:
        config = Config()
        tracker = Tracker(TRACKING_ID, 'steeve.io', conf=config)
        session = ga.setdefault("session", Session())
        if not ga.get("visitor"):
            ga["visitor"] = make_visitor()
        return tracker, session, ga["visitor"]


def get_platform():
    platforms = {
        "Linux": "X11; Linux",
        "Windows": "Windows NT %d.%d",
        "OSX": "Macintosh; Intel Mac OS X",
        "IOS": "iPad; CPU OS 6_1 like Mac OS X",
    }
    for platform, ua_platform_name in platforms.items():
        if xbmc.getCondVisibility("System.Platform.%s" % platform):
            if platform == "Windows":
                import sys
                version = sys.getwindowsversion()
                ua_platform_name %= (version[0], version[1])
            return ua_platform_name


def get_user_agent():
    return "XBMC/%s (%s)" % (
        xbmc.getInfoLabel("System.BuildVersion").split(" ")[0],
        get_platform()
    )


def tracked(*args, **kwargs):
    def _track(fn):
        @wraps(fn)
        def _fn(*a, **kwds):
            track_page(plugin.request.path, force=kwargs.pop("force", False))
            return fn(*a, **kwds)
        return _fn
    if len(args) == 1 and callable(args[0]):
        return _track(args[0])
    return _track


def track_page(path, force=False):
    if not plugin.get_setting("ga_disable", bool) or force:
        try:
            from pyga.requests import Page
            tracker, session, visitor = get_ga()
            plugin.log.info("GA: Tracking %s" % path)
            tracker.track_pageview(Page(path), session, visitor)
        except Exception, e:
            import traceback
            plugin.log.error("GA: Call failed.")
            plugin.log.error(traceback.format_exc())


def track_event(*args, **kwargs):
    if not plugin.get_setting("ga_disable", bool) or kwargs.pop("force", False):
        try:
            from pyga.requests import Event
            tracker, session, visitor = get_ga()
            plugin.log.info("GA: Tracking event %s" % repr(args))
            tracker.track_event(Event(*args, **kwargs), session, visitor)
        except Exception, e:
            import traceback
            plugin.log.error("GA: Call failed.")
            plugin.log.error(traceback.format_exc())
