from bonetorrent import plugin
from bonetorrent.scrapers import scraper
from bonetorrent.ga import tracked
from bonetorrent.caching import cached_route
from bonetorrent.utils import ensure_fanart
from bonetorrent.library import library_context


BASE_URL = plugin.get_setting("base_btdigg")
HEADERS = {
    "Referer": BASE_URL,
}
SORT_RELEVANCE = 0
SORT_POPULARITY = 1
SORT_ADDTIME = 2
SORT_SIZE = 3
SORT_FILES = 4


@scraper("%s"%plugin.get_setting("btdigg_label"), "%s"%plugin.get_setting("btdigg_picture"))
@plugin.route("/btdigg")
@ensure_fanart
@tracked
def btdigg_index():
    plugin.redirect(plugin.url_for("btdigg_search"))


@plugin.route("/btdigg/search/<query>/<sort>/<page>")
@library_context
@ensure_fanart
@tracked
def btdigg_page(query, sort, page):
    from bs4 import BeautifulSoup
    from bonetorrent.utils import url_get

    html_data = url_get("%s/search" % BASE_URL, headers=HEADERS, params={
        "order": sort,
        "q": query,
        "p": page,
    })
    soup = BeautifulSoup(html_data, "html5lib")
    name_nodes = soup.findAll("td", "torrent_name")
    attr_nodes = soup.findAll("table", "torrent_name_tbl")[1::2]

    for name_node, attr_node in zip(name_nodes, attr_nodes):
        attrs = attr_node.findAll("span", "attr_val")
        title = "%s (%s, DLs:%s)" % (name_node.find("a").text, attrs[0].text, attrs[2].text)
        yield {
            "label": title,
            "path": plugin.url_for("play", uri=attr_node.find("a")["href"]),
            "is_playable": True,
        }
    yield {
        "label": ">> Next page",
        "path": plugin.url_for("btdigg_page", query=query, sort=sort, page=int(page) + 1),
        "is_playable": False,
    }


@plugin.route("/btdigg/search")
@tracked
def btdigg_search():
    query = plugin.request.args_dict.pop("query", None)
    if not query:
        query = plugin.keyboard("", "bonetorrent - BTDigg - Search")
    if query:
        plugin.redirect(plugin.url_for("btdigg_page", query=query, sort=SORT_POPULARITY, page=0, **plugin.request.args_dict))
