import socket
from bonetorrent import plugin, magnet, scrapers
from bonetorrent.ga import tracked
from bonetorrent.utils import ensure_fanart
from bonetorrent.platform import PLATFORM

scrapers = ["eztv","yify","tpb","kickass","bitsnoop","btdigg","extratorrent","nyaa","zelka","cpb"]
scrapersToDisplay = []
for scraper in scrapers:
    if plugin.get_setting("display_%s"%scraper, bool):
        scrapersToDisplay.append("%s"%scraper)

from bonetorrent.scrapers import \
    MODULES
for scraper in scrapersToDisplay:
    __import__("bonetorrent.scrapers", fromlist=[scraper])

@plugin.route("/")
@ensure_fanart
@tracked(force=True)
def index():
    if PLATFORM["os"] not in ["android", "linux", "windows", "darwin"]:
        plugin.notify("Your system \"%(os)s_%(arch)s\" is not supported." % PLATFORM, delay=15000)

    for module in MODULES:
        yield {
            "label": module["name"],
            "thumbnail": module["image"],
            "path": plugin.url_for(module["view"]),
        }
