import os
from bonetorrent import plugin


LIBRARY_PATHS = {
    "bonetorrent Movies": {
        "strContent": "movies",
        "strScraper": "metadata.themoviedb.org",
        "useFolderNames": 0,
        "strSettings": """<settings><setting id="RatingS" value="TMDb" /><setting id="TrailerQ" value="No" /><setting id="certprefix" value="Rated " /><setting id="fanart" value="true" /><setting id="keeporiginaltitle" value="false" /><setting id="language" value="en" /><setting id="tmdbcertcountry" value="us" /><setting id="trailer" value="true" /></settings>""",
        "strPath": "special://profile/addon_data/%s/movies/" % plugin.id,
    },
    "bonetorrent TV": {
        "strContent": "tvshows",
        "strScraper": "metadata.tvdb.com",
        "useFolderNames": 0,
        "strSettings": """<settings><setting id="absolutenumber" value="false" /><setting id="dvdorder" value="false" /><setting id="fanart" value="true" /><setting id="language" value="en" /></settings>""",
        "strPath": "special://profile/addon_data/%s/tv/" % plugin.id,
    },
}


def _get_video_db():
    import xbmc
    versions = {"12": "75", "13": "78"}
    major = xbmc.getInfoLabel("System.BuildVersion").split(".")[0]
    return xbmc.translatePath("special://database/MyVideos%s.db" % versions[major])


def _rescan_library(path=None):
    import json
    import xbmc
    params = {}
    if path:
        params["directory"] = path
    xbmc.executeJSONRPC(json.dumps({
        "jsonrpc": "2.0",
        "id": 1,
        "method": "VideoLibrary.Scan",
        "params": params,
    }))


@plugin.route("/library/<content_type>/add")
def library_add(content_type):
    import os
    import xbmc
    import xbmcgui
    from bonetorrent.magnet import ensure_magnet, display_name
    from bonetorrent.utils import get_show_info_from_name
    from urllib import quote_plus, unquote

    play_url = "plugin.video.bcreborn/?action=play&amp;url="
    for name, entry in LIBRARY_PATHS.items():
        if entry["strContent"] == content_type:

            if not xbmcgui.Dialog().yesno("Add to %s" % name, "Add \"%s\" to %s ?" % (plugin.request.args_dict["label"], name), ""):
                return
            
            if content_type == "tvshows" and plugin.get_setting("library_tv_path") != "":
                real_path = plugin.get_setting("library_tv_path")
            elif content_type == "movies" and plugin.get_setting("library_movies_path") != "":
                real_path = plugin.get_setting("library_movies_path")
            else:
                real_path = xbmc.translatePath(entry["strPath"])
    
            if not os.path.exists(real_path):
                os.makedirs(real_path)
            '''
            movies_path = os.path.join(real_path, "movies")
            tv_path = os.path.join(real_path, "tv")
            if not os.path.exists(movies_path):
                os.makedirs(movies_path)
            if not os.path.exists(tv_path):
                os.makedirs(tv_path)
            '''
            uri = unquote(plugin.request.args_dict["href"].replace(play_url, ""))
            magnet_uri = ensure_magnet(uri)
            filename = display_name(magnet_uri)
            if not filename:
                plugin.notify("Unable to add this file. Magnet is incomplete.")
                return
            if content_type == "tvshows":
                show_info = get_show_info_from_name(filename)
                if show_info:
                    real_path = os.path.join(real_path, show_info["show"])
                    if not os.path.exists(real_path):
                        os.makedirs(real_path)
                        
            with open(os.path.join(real_path, "%s.strm" % filename), "w") as fp:
                fp.write("%s%s" % (play_url, quote_plus(magnet_uri)))
            _rescan_library(entry["strPath"])
            plugin.notify("Added to %s." % name)
            break

def library_context(fn):
    """Makes sure that if the listitem doesn't have a fanart, we properly set one."""
    from functools import wraps
    import urlparse
    @wraps(fn)
    def _fn(*a, **kwds):
        items = fn(*a, **kwds)
        if items is not None:
            for item in items:
                if item.get("is_playable"):
                    label = item["label"].encode("utf-8")
                    item.setdefault("context_menu", []).extend([
                        ("Add to Movies", "XBMC.RunPlugin(%s)" % plugin.url_for("library_add", content_type="movies", label=label, href=item["path"])),
                        ("Add to TV", "XBMC.RunPlugin(%s)" % plugin.url_for("library_add", content_type="tvshows", label=label, href=item["path"])),
                    ])
                yield item
    return _fn
