from bonetorrent import plugin
from bonetorrent.scrapers import scraper
from bonetorrent.ga import tracked
from bonetorrent.caching import cached_route
from bonetorrent.utils import ensure_fanart


BASE_URL = "%s/" % plugin.get_setting("base_extratorrent")
HEADERS = {
    "Referer": BASE_URL,
}
# Cache TTLs
DEFAULT_TTL = 24 * 3600 # 24 hours

MOVIES_CATEGORIES = [
    ("Action", "419"),
    ("Adventure", "28"),
    ("Animation", "29"),
    ("Asian", "30"),
    ("Automotive/Cars", "32"),
    ("Biography", "628"),
    ("Bollywood", "558"),
    ("Comedy", "33"),
    ("Concerts", "34"),
    ("Crime", "600"),
    ("Documentary", "35"),
    ("Drama", "37"),
    ("Dubbed Movies", "742"),
    ("DVD / Film Extras", "36"),
    ("Family", "149"),
    ("Fantasy", "38"),
    ("Gore Flicks", "39"),
    ("History", "602"),
    ("Horror", "40"),
    ("Kids", "41"),
    ("KVCD", "150"),
    ("Martial Arts", "42"),
    ("Movies - Other", "44"),
    ("Movies 3D", "805"),
    ("Mystery", "43"),
    ("non English", "603"),
    ("Romance", "45"),
    ("Samples / Trailers", "46"),
    ("Sci-Fi", "47"),
    ("Sports related", "48"),
    ("Stand-up comedy", "779"),
    ("Thriller", "49"),
    ("Travel", "671"),
    ("War", "307"),
    ("Western", "601"),
]


@scraper("%s"%plugin.get_setting("extratorrent_label"), "%s"%plugin.get_setting("extratorrent_picture"))
@plugin.route("/extratorrent")
@ensure_fanart
@tracked
def extratorrent_index():
    cats = [
        {"label": "Search Movies", "path": plugin.url_for("extratorrent_search", cid="4", content_type="movies")},
        {"label": "Search TV Episodes", "path": plugin.url_for("extratorrent_search", cid="8")},
        {"label": "Search Anime", "path": plugin.url_for("extratorrent_search", cid="1")},
        {"label": "Popular Movies", "path": plugin.url_for("extratorrent_page", type_="popular", cid="4", content_type="movies")},
        {"label": "Popular TV Episodes", "path": plugin.url_for("extratorrent_page", type_="popular", cid="8")},
        {"label": "Popular Anime", "path": plugin.url_for("extratorrent_page", type_="popular", cid="1")},
        {"label": "Last Movies", "path": plugin.url_for("extratorrent_page", type_="last", cid="4", content_type="movies")},
        {"label": "Last TV Episodes", "path": plugin.url_for("extratorrent_page", type_="last", cid="8")},
        {"label": "Last Anime", "path": plugin.url_for("extratorrent_page", type_="last", cid="1")},
    ]
    return cats


@plugin.route("/extratorrent/search/<search>", name="extratorrent_page_search")
@plugin.route("/extratorrent/browse/<type_>/<cid>")
@ensure_fanart
@tracked
def extratorrent_page(type_="", cid="", search="", page=1):
    from urlparse import urljoin
    from bonetorrent.scrapers import rss
    from bonetorrent.utils import url_get

    content_type = plugin.request.args_dict.pop("content_type", None)
    if content_type:
        plugin.set_content(content_type)

    params = {
        "type": type_,
        "search": search,
        "cid": cid,
    }
    params.update(plugin.request.args_dict)
    page_data = url_get(urljoin(BASE_URL, "/rss.xml"), headers=HEADERS, params=params)
    return rss.parse(page_data, content_type)


@plugin.route("/extratorrent/search")
@tracked
def extratorrent_search():
    query = plugin.request.args_dict.pop("query", None)
    if not query:
        query = plugin.keyboard("", "bonetorrent - ExtraTorrent - Search")
    if query:
        plugin.redirect(plugin.url_for("extratorrent_page_search", type="search", search=query, **plugin.request.args_dict))
