# -*- coding: utf-8 -*-

from bonetorrent import plugin
from bonetorrent.scrapers import scraper
from bonetorrent.ga import tracked
from bonetorrent.caching import cached_route
from bonetorrent.utils import ensure_fanart
from bonetorrent.library import library_context

import bonetorrent.magnet as magnet
import requests
import re
from bs4 import BeautifulSoup
from bs4 import SoupStrainer

CUSTOM_TRACKERS = [
    "http://tracker.zelka.org/announce.php?passkey=28878cff72aef4b3d08765455c64c1bb",
    "http://flashtorrents.org/announce.php",
    "http://94.228.192.98/announce",
    "udp://9.rarbg.com:2710/announce"
]
magnet.PUBLIC_TRACKERS += CUSTOM_TRACKERS

BASE_URL = plugin.get_setting("base_zelka")
categories = [{'cat_ids':'5','cat_name':u'Hd Movies'},
              {'cat_ids':'31','cat_name':u'Science Movies'},
              {'cat_ids':'28','cat_name':u'Russian Movies'},
              {'cat_ids':'35','cat_name':u'x264 Movies'},
              {'cat_ids':'24','cat_name':u'Bg Movies'},
              {'cat_ids':'33','cat_name':u'Hd Series'},
              {'cat_ids':'7','cat_name':u'Series'},
              {'cat_ids':'43','cat_name':u'Hd Sport'}]

categories_xxx = [{'cat_ids':'9','cat_name':u'XXX'},
                  {'cat_ids':'49','cat_name':u'Hd XXX'}]

fnd = {
  'search' : '',
  'page' : '0',
  'cat' : '',
  'incldead' : '0',
  'in' : 'name'}

HEADERS = {
  "Host" : BASE_URL.split('//')[1],
  "User-Agent" : "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:32.0) Gecko/20100101 Firefox/32.0"
}

if plugin.get_setting("porn", bool):
  categories += categories_xxx

ids = [d['cat_ids'] for d in categories]

def do_login():
  r = s.post('%s/takelogin.php' % BASE_URL, data={'username' : plugin.get_setting('z_usr'), 'password' : plugin.get_setting('z_pass')}, headers = HEADERS)
  if re.search(plugin.get_setting('z_usr'), r.text, re.IGNORECASE):
    return True

def do_logout():
  s.get('%s/logout.php' % BASE_URL, headers = HEADERS)

def _info_get (txt):
  if txt:
    txt = re.sub(r"Tip\('|'\)", '', txt)
    ff = BeautifulSoup(txt, "html5lib")
    return {'img': ff.find('img').get('src'),'info': re.sub( r'(?:\s+)', ' ', ff.get_text(' '))}
  else:
    return {'img': 'DefaultVideo.png', 'info': ''}
    

@scraper(str(plugin.get_setting("zelka_label")), str(plugin.get_setting("zelka_picture")))
@plugin.route("/zelka")
@ensure_fanart
@tracked
def zelka_index():
  yield {'label': u'Search latest','path': plugin.url_for('zelka_search', cat='0')}
  yield {'label': u'Browse latest','path': plugin.url_for('zelka_page', cat='0', page=0, query=u'!br!')}
  for cat in categories:
    #yield {'label': u'Search ' + cat['cat_name'],'path': plugin.url_for('zelka_search', cat=cat['cat_ids'])}
    yield {'label': u'Browse ' + cat['cat_name'],'path': plugin.url_for('zelka_page', cat=cat['cat_ids'], page=0, query=u'!br!')}

@plugin.route("/zelka/zelka_page/<page>/<cat>/<query>")
@library_context
@ensure_fanart
@tracked
def zelka_page(page, cat, query):
  global s
  s = requests.Session()
  fnd['page'] = page
  fnd['cat'] = cat
  if query != u'!br!':
    fnd['search'] = query

  if do_login():
    r = s.get('%s/browse.php' % BASE_URL, params=fnd, headers = HEADERS)
    sp = BeautifulSoup(r.text, "html5lib")
    for link in sp.findAll('a', href=re.compile(r'magnet:\?xt=.*')):
      pr = link.find_parent('td')
      if cat != '0' or pr.find_previous_sibling('td').find('a', href=re.compile(r'browse\.php\?cat=\d+'))['href'].split('=')[1] in ids:
        ss = pr.find_next_siblings('td')
        dat = pr.find('a', href=re.compile(r'details\.php\?id=\d+'))
        title = "%s (%s, DLs:%s)" % (dat.string, ss[3].get_text(' '), ss[5].string)
        r = _info_get(dat.get('onmouseover'))
        yield {
            "label": title,
            "path": plugin.url_for("play", uri=link['href']),
            "is_playable": True,
            "info": {"plot": r['info']},
            "thumbnail": r['img'],
            "properties": {"fanart_image": r['img']}
        }
    nn = sp.find('b', text=re.compile(u'(?:Следваща.)'))
    if nn and nn.find_parent('a'):
      yield {
          "label": ">> Next page",
          "path": plugin.url_for("zelka_page", query=query, cat=cat, page=int(page) + 1),
          "is_playable": False,
      }
    do_logout()
  s.close()
  plugin.set_content('movies')

@plugin.route("/zelka/search")
@tracked
def zelka_search():
  cat = plugin.request.args_dict.pop('cat', '0')
  query = plugin.keyboard('', "XBMCtorrent - Zelka.org - Search")
  if query:
    plugin.redirect(plugin.url_for("zelka_page", query=query, cat=cat, page=0, **plugin.request.args_dict))
