import os
from bonetorrent import plugin


@plugin.route("/cmd/install")
def firstrun():
    clear_cache()
    plugin.notify("Please review your settings.")
    plugin.open_settings()


@plugin.route("/cmd/clear_cache")
def clear_cache():
    import os
    '''
    import glob
    from bonetorrent.caching import CACHE_DIR
    for directory in [CACHE_DIR, plugin.storage_path]:
        for dbfile in glob.glob(os.path.join(directory, "*.db")):
            os.remove(dbfile)
    '''
    from bonetorrent.caching import CACHE_DIR
    fileList = os.listdir(CACHE_DIR)
    for file in fileList:
        os.remove(os.path.join(CACHE_DIR, file))
    plugin.notify("Cache cleared.")


firstrun_file = os.path.join(plugin.addon.getAddonInfo("path"), ".firstrun")
if not os.path.exists(firstrun_file):
    with open(firstrun_file, "w"):
        firstrun()
