from bonetorrent import plugin
from bonetorrent.scrapers import scraper
from bonetorrent.ga import tracked
from bonetorrent.caching import cached_route
from bonetorrent.utils import ensure_fanart


BASE_URL = "%s/" % plugin.get_setting("base_kickass")
HEADERS = {
    "Referer": BASE_URL,
}

MOVIES_GENRES = [
    "Action", "Adult", "Adventure", "Animation", "Biography", "Comedy", "Crime",
    "Documentary", "Drama", "Family", "Fantasy", "Film Noir", "Game Show",
    "History", "Horror", "Music", "Musical", "Mystery", "News", "Reality Tv",
    "Romance", "Sci Fi", "Short", "Sport", "Talk Show", "Thriller", "War",
    "Western",
]

MOVIES_CATEGORIES = [
    "3D Movies", "Music videos", "Movie clips", "Handheld", "iPad",
    "Highres Movies", "Bollywood", "Concerts", "Dubbed Movies", "Asian",
    "Documentary", "Trailer", "Other Movies",
]

TV_TAGS = [
    "Action", "Adventure", "Animation General", "Anime", "Anthology",
    "Celebrities", "Children", "Children Cartoons", "Comedy", "Cooking Food",
    "Cooking-Food", "Crime", "Current Events", "Discovery Science",
    "Discovery-Science", "Drama", "Educational", "Family", "Fantasy", "History",
    "Horror Supernatural", "How To Do It Yourself", "How-To-Do-It-Yourself",
    "Interview", "Lifestyle", "Medical", "Military War", "Music", "Mystery",
    "Pets Animals", "Politics", "Romance Dating", "Romance-Dating", "Sci Fi",
    "Sketch Improv", "Soaps", "Sports", "Talent", "Teens", "Thriller", "Travel",
    "Wildlife"
]

ANIME_GENRES = [
    "Action", "Adventure", "Angst", "Asia", "Calling Your Attacks", "Comedy",
    "Coming Of Age", "Contemporary Fantasy", "Daily Life", "Demons", "Earth",
    "Ecchi", "Fantasy", "Fantasy World", "Friendship", "Future", "Game",
    "Harem", "High School", "Japan", "Magic", "Manga", "Martial Arts", "Mecha",
    "New", "Novel", "Nudity", "Past", "Plot Continuity", "Present", "Romance",
    "School Life", "Sci-Fi", "Seinen", "Shoujo", "Shounen", "Slapstick",
    "Stereotypes", "Super Power", "Swordplay", "Tragedy", "Violence",
]

# Cache TTLs
DEFAULT_TTL = 24 * 3600 # 24 hours


def norm_cat(cat):
    return cat.lower().replace(" ", "-")


@scraper("%s"%plugin.get_setting("kat_label"), "%s"%plugin.get_setting("kat_picture"))
@plugin.route("/kat")
@ensure_fanart
@tracked
def kat_index():
    cats = [
        {"label": "Search", "path": plugin.url_for("kat_search", sort_field="seeders", sort_order="desc")},
        {"label": "Movies", "path": plugin.url_for("kat_movies")},
        {"label": "Series", "path": plugin.url_for("kat_series", sort_field="seeders", sort_order="desc")},
        {"label": "Anime", "path": plugin.url_for("kat_anime")},
    ]
    if plugin.get_setting("porn", bool):
        cats += [
            {"label": "XXX", "path": plugin.url_for("kat_porn")},
        ]
    return cats


@plugin.route("/kat/movies")
@ensure_fanart
@tracked
def kat_movies():
    return [
        {"label": "Search Movies", "path": plugin.url_for("kat_search", query_suffix="category:movies", sort_field="seeders", sort_order="desc", content_type="movies")},
        {"label": "Genres", "path": plugin.url_for("kat_movies_genres")},
        {"label": "Most Popular", "path": plugin.url_for("kat_page", root="movies", page=1, sort_field="seeders", sort_order="desc", content_type="movies")},
        {"label": "    in 720p", "path": plugin.url_for("kat_search", query="720p category:movies", sort_field="seeders", sort_order="desc", content_type="movies")},
        {"label": "    in 1080p", "path": plugin.url_for("kat_search", query="1080p category:movies", sort_field="seeders", sort_order="desc", content_type="movies")},
        {"label": "    in 3D", "path": plugin.url_for("kat_search", query="category:3d-movies", sort_field="seeders", sort_order="desc", content_type="movies")},
        {"label": "Most Recent", "path": plugin.url_for("kat_page", root="movies", page=1, sort_field="time_add", sort_order="desc", content_type="movies")},
        {"label": "    in 720p", "path": plugin.url_for("kat_search", query="720p category:movies", sort_field="time_add", sort_order="desc", content_type="movies")},
        {"label": "    in 1080p", "path": plugin.url_for("kat_search", query="1080p category:movies", sort_field="time_add", sort_order="desc", content_type="movies")},
        {"label": "    in 3D", "path": plugin.url_for("kat_search", query="category:3d-movies", sort_field="time_add", sort_order="desc", content_type="movies")},
    ]

@plugin.route("/kat/movies/genres")
@ensure_fanart
@tracked
def kat_movies_genres():
    for genre in MOVIES_GENRES:
        yield {"label": genre, "path": plugin.url_for("kat_search", query="category:movies genre:%s" % norm_cat(genre), sort_field="seeders", sort_order="desc", content_type="movies")}


@plugin.route("/kat/series")
@ensure_fanart
@tracked
def kat_series():
    return [
        {"label": "Search Episodes", "path": plugin.url_for("kat_search", query_suffix="category:tv", sort_field="seeders", sort_order="desc")},
        {"label": "All Episodes", "path": plugin.url_for("kat_page", root="tv", page=1, sort_field="seeders", sort_order="desc")},
        {"label": "    HD", "path": plugin.url_for("kat_search", query="(1080p OR 720p) category:tv", sort_field="seeders", sort_order="desc")},
        {"label": "    720p", "path": plugin.url_for("kat_search", query="720p category:tv", sort_field="seeders", sort_order="desc")},
        {"label": "    1080p", "path": plugin.url_for("kat_search", query="1080p category:tv", sort_field="seeders", sort_order="desc")},
    ]


@plugin.route("/kat/anime")
@ensure_fanart
@tracked
def kat_anime():
    return [
        {"label": "Search Anime", "path": plugin.url_for("kat_search", query_suffix="category:anime", sort_field="seeders", sort_order="desc")},
        {"label": "All Anime", "path": plugin.url_for("kat_page", root="tv", page=1, sort_field="seeders", sort_order="desc")},
        {"label": "    HD", "path": plugin.url_for("kat_search", query="(1080p OR 720p) category:anime", sort_field="seeders", sort_order="desc")},
        {"label": "    720p", "path": plugin.url_for("kat_search", query="720p category:anime", sort_field="seeders", sort_order="desc")},
        {"label": "    1080p", "path": plugin.url_for("kat_search", query="1080p category:anime", sort_field="seeders", sort_order="desc")},
    ]


@plugin.route("/kat/porn")
@ensure_fanart
@tracked
def kat_porn():
    return [
        {"label": "XXX", "path": plugin.url_for("kat_page", root="xxx", page=1, sort_field="seeders", sort_order="desc")},
        {"label": "    HD", "path": plugin.url_for("kat_page", root="xxx-hd-video", page=1, sort_field="seeders", sort_order="desc")},
        {"label": "    Hentai", "path": plugin.url_for("kat_page", root="hentai", page=1, sort_field="seeders", sort_order="desc")},
    ]


@plugin.route("/kat/browse/<root>/<page>/<sort_field>/<sort_order>")
@ensure_fanart
@tracked
def kat_page(root, page, sort_field, sort_order):
    from urlparse import urljoin
    from bonetorrent.scrapers import rss
    from bonetorrent.utils import url_get

    content_type = plugin.request.args_dict.get("content_type")
    if content_type:
        plugin.set_content(content_type)

    page = int(page)
    page_data = url_get(urljoin(BASE_URL, "%s/%d" % (root, page)), headers=HEADERS, params={
        "rss": "1",
        "field": sort_field,
        "sorder": sort_order
    })
    for item in rss.parse(page_data, content_type):
        yield item
    yield {
        "label": ">> Next page",
        "path": plugin.url_for("kat_page", root=root, page=page + 1, sort_field=sort_field, sort_order=sort_order, **plugin.request.args_dict),
    }


@plugin.route("/kat/search")
@tracked
def kat_search():
    import urllib
    query = plugin.request.args_dict.pop("query", None)
    suffix = plugin.request.args_dict.pop("query_suffix", "")
    if not query:
        query = plugin.keyboard("", "bonetorrent - Kickass Torrent - Search")
    if query:
        plugin.redirect(plugin.url_for("kat_page", root="usearch/%s" % urllib.quote("%s %s verified:1" % (query, suffix), safe=""), page=1, **plugin.request.args_dict))
