from bonetorrent import plugin
from bonetorrent.scrapers import scraper
from bonetorrent.ga import tracked
from bonetorrent.caching import cached_route
from bonetorrent.utils import ensure_fanart


# Temporary, will be fixed later by them
BASE_URL = "%s/" % plugin.get_setting("base_nyaa")
HEADERS = {
    "Referer": BASE_URL,
}


CATEGORIES = [
    ("Anime", "1_0", (
        ("English-translated Anime", "1_37"),
        ("Raw Anime", "1_11"),
        ("Non-English-translated Anime", "1_38"),
        ("Anime Music Video", "1_32"),
    )),
    ("Live Action (movies)", "5_0", (
        ("English-translated Live Action", "5_19"),
        ("Raw Live Action", "5_20"),
        ("Non-English-translated Live Action", "5_21"),
        ("Live Action Promotional Video", "5_22"),
    )),
]

SORT_DATE = 1
SORT_SEEDERS = 2
SORT_LEECHERS = 3
SORT_DOWNLOADS = 4
SORT_SIZE = 5
SORT_NAME = 6

SORT_DESCENDING = 1
SORT_ASCENDING = 2

# Cache TTLs
DEFAULT_TTL = 2 * 3600 # 2 hours


@scraper("%s"%plugin.get_setting("nyaa_label"), "%s"%plugin.get_setting("nyaa_picture"))
@plugin.route("/nyaa")
@tracked
def nyaa_index():
    yield {"label": "Search", "path": plugin.url_for("nyaa_search")}

    def make_cats(root, prefix=""):
        for cat in root:
            yield {
                "label": "%s%s" % (prefix, cat[0]),
                "path": plugin.url_for("default_nyaa_page", cats=cat[1], offset=0, sort=SORT_SEEDERS, order=SORT_DESCENDING),
            }
            if len(cat) > 2:
                for entry in make_cats(cat[2], prefix="%s    " % prefix):
                    yield entry

    for cat in make_cats(CATEGORIES):
        yield cat


@plugin.route("/nyaa/show/<cats>/<offset>/<sort>/<order>")
@tracked
def default_nyaa_page(cats, offset, sort, order):
    return nyaa_page(cats, offset, sort, order)


@plugin.route("/nyaa/search/<term>/<offset>/<sort>/<order>")
@tracked
def search_result_page(term, offset, sort, order):
    return nyaa_page("1_0", offset, sort, order, term)


def nyaa_page(cats, offset, sort, order, term=""):
    from bonetorrent.scrapers import rss
    from bonetorrent.utils import url_get

    offset = int(offset)
    rss_data = url_get(BASE_URL, headers=HEADERS, params={
        "cats": cats,
        "offset": "%d" % offset,
        "sort": sort,
        "order": order,
        "term": term,
        "page": "rss",
    })
    for item in rss.parse(rss_data):
        yield item
    yield {
        "label": ">> Next page",
        "path": plugin.url_for(term and "search_result_page" or "default_nyaa_page", cats=cats, sort=sort, order=order, term=term, offset=offset + 1),
        "is_playable": False,
    }


@plugin.route("/nyaa/search")
@tracked
def nyaa_search():
    query = plugin.request.args.get("query")
    if query:
        query = query[0]
    else:
        query = plugin.keyboard("", "bonetorrent - NyaaTorrents - Search")
    if query:
        plugin.redirect(plugin.url_for("search_result_page", page="search", cats="0_0", filter=0, term=query, offset=1, sort=SORT_DATE, order=SORT_DESCENDING))
