"""
    Plugin for bonesresolver
    Copyright (C) 2019 gujal

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
"""

import re
from bonesresolver.plugins.lib import helpers
from bonesresolver import common
from bonesresolver.resolver import bonesresolver, ResolverError


class ViuclipsResolver(bonesresolver):
    name = "viuclips"
    domains = ["viuclips.net", "veuclips.com"]
    pattern = r'(?://|\.)(v[ie]uclips\.(?:net|com))/(?:embed/)?([0-9a-zA-Z]+)'

    def get_media_url(self, host, media_id):
        web_url = self.get_url(host, media_id)
        headers = {'User-Agent': common.FF_USER_AGENT}
        response = self.net.http_GET(web_url, headers=headers)
        html = response.content
        if 'video has been removed' not in html:
            source = re.findall('hls:"([^"]+)', html)[0]
            return source + helpers.append_headers({'User-Agent': common.FF_USER_AGENT})

        raise ResolverError('File Not Found or removed')

    def get_url(self, host, media_id):
        return self._default_get_url(host, media_id, template='https://player.viuclips.net/embed/{media_id}')
