import java.util.ArrayList;
import java.util.Scanner;

public class AbridgedReading_WA_John {

	public static final int MAXN = 1000;
	
	public static Node_WA[] nodes = new Node_WA[MAXN+1];
	public static int minCost1, minCost2;
	
	public static void process(Node_WA n, int cost)
	{
		if (n.children.size() == 0) {
			if (cost +n.value <= minCost1) {
				minCost2 = minCost1;
				minCost1 = cost + n.value;
			}
			else if (cost+n.value < minCost2)
				minCost2 = cost+n.value;
		}
		else {
			for(int i=0; i<n.children.size(); i++)
				process(n.children.get(i), cost+n.value);
		}
	}
	
	public static void main(String[] args) {

		int n, m, max = 0;
		Scanner in = new Scanner(System.in);
		
		n = in.nextInt();
		m = in.nextInt();
		
		for(int i=1; i<=n; i++) {
			nodes[i] = new Node_WA();
			nodes[i].value = in.nextInt();
			max += nodes[i].value;
		}
		for(int i=0; i<m; i++) {
			int p = in.nextInt();
			int c = in.nextInt();
			nodes[p].children.add(nodes[c]);
			nodes[c].hasParent = true;
		}
		nodes[0] = new Node_WA();
		for(int i=1; i<=n; i++) {
			if (!nodes[i].hasParent)
				nodes[0].children.add(nodes[i]);
		}
		minCost1 = max;
		minCost2 = max;
		process(nodes[0], 0);
		System.out.println(minCost1+minCost2);
	}

}

class Node_WA
{
	public ArrayList<Node_WA> children = new ArrayList<>();
	public int value;
	public boolean hasParent = false;
}
