import java.util.ArrayList;
import java.util.Scanner;
import java.util.StringTokenizer;

public class JohnChecker
{
	public static final int MAX_SIZE = 30;
	public static int exitCode = 42;

	public static void printError(int line, String msg)
	{
		System.out.println("ERROR Line " + line + ": " + msg);
		exitCode = -1;
	}

	public static void checkIntBounds(int x, int min, int max, String name, int nLines)
	{
		if (x < min || x > max)
			printError(nLines, "invalid " + name + " value: " + x);
	}

	public static void checkCharBounds(char x, char min, char max, String name, int nLines)
	{
		if (x < min || x > max)
			printError(nLines, "invalid " + name + " value: " + x);
	}

	public static void checkDoubleBounds(double x, double min, double max, String name, int nLines)
	{
		if (x < min || x > max)
			printError(nLines, "invalid " + name + " value: " + x);
	}

	public static int nextInt(StringTokenizer st)
	{
		return Integer.parseInt(st.nextToken());
	}

	public static void main(String [] args)
	{
		Scanner in = new Scanner(System.in);
		int m;
		int [] pieces;
		String line;
		int nLines=0;
		StringTokenizer st;

		for(int j=0; j<3; j++) {
			if (!in.hasNextLine()) {
				printError(nLines, "not enough lines in input file");
				break;
			}
			line = in.nextLine();
			nLines++;
			st = new StringTokenizer(line);
			m = nextInt(st);
			checkIntBounds(m, 1, MAX_SIZE, "m", nLines);
			if (st.countTokens() != m)
				printError(nLines, "number of values on line incorrect");
			pieces = new int[st.countTokens()];
			boolean [] found = new boolean[31];
			for(int i=0; i<m; i++) {
				int val = nextInt(st);
				checkIntBounds(val, 1, MAX_SIZE, i+"th piece", nLines);
				if (found[val])
					printError(nLines, "repeated piece: " + val);
				found[val] = true;
				pieces[i] = val;
			}
			if (pieces.length > 1 && !okPiece(pieces)) {
				printError(nLines, "unconnected piece");
			}
		}
		if (in.hasNextLine())
			printError(nLines+1, "too many lines in input file");
		System.exit(exitCode);
	}

	public static boolean okPiece(int [] pieces)
	{
		int [][] adj = {{0,0,0,0}, {2,5,6,10},   {1,3,6,7},    {2,4,7,8},    {3,5,8,9},    {1,4,9,10},
								   {1,2,11,20},  {2,3,12,13},  {3,8,14,15},  {4,5,16,17},  {1,5,18,19},
								   {6,12,20,21}, {7,11,13,21}, {7,12,14,22}, {8,13,15,22}, {8,14,16,23},
								   {9,15,17,23}, {9,16,18,24}, {10,17,19,24},{10,18,20,25},{6,11,19,25},
								   {11,12,26,27},{13,14,27,28},{15,16,28,29},{17,18,29,30},{19,20,26,30},
								   {21,25,27,30},{21,22,26,28},{22,23,27,29},{23,24,28,30},{24,25,26,29}
		};
		boolean [] connected = new boolean[31];
		for(int i=0; i<pieces.length; i++) {
			int p = pieces[i];
			for(int j=0; j<adj[p].length; j++) {
				connected[adj[p][j]] = true;
			}
		}
		for(int i=0; i<pieces.length; i++) {
			int p = pieces[i];
			if (!connected[p])
				return false;
		}
		return true;
	}
}