#include <iostream>

using namespace std;

#define repi(ctr,start,limit) for (uint32_t ctr=(start);(ctr)<(limit);(ctr)++)

const uint32_t
    neighbors[31][4] =
        {
                { 0, 0, 0, 0},

                { 2, 5, 6,10},
                { 1, 3, 6, 7},
                { 2, 4, 7, 8},
                { 3, 5, 8, 9},
                { 1, 4, 9,10},

                { 1, 2,11,20},
                { 2, 3,12,13},
                { 3, 4,14,15},
                { 4, 5,16,17},
                { 1, 5,18,19},

                { 6,12,20,21},
                { 7,11,13,21},
                { 7,12,14,22},
                { 8,13,15,22},
                { 8,14,16,23},

                { 9,15,17,23},
                { 9,16,18,24},
                {10,17,19,24},
                {10,18,20,25},
                { 6,19,11,25},

                {11,12,26,27},
                {13,14,27,28},
                {15,16,28,29},
                {17,18,29,30},
                {19,20,26,30},

                {27,30,21,25},
                {26,28,21,22},
                {27,29,22,23},
                {28,30,23,24},
                {29,26,24,25}
        };

bool
    exist[31],
    used[31];

void visit(uint32_t v) {

    used[v] = true;

    for (uint32_t w=0;w<4;w++)
        if (exist[neighbors[v][w]] && !used[neighbors[v][w]])
            visit(neighbors[v][w]);
}

int main() {
    uint32_t
        nComp,
        n,
        w;

    repi(s,0,3) {
        repi(w,0,31)
          exist[w] = used[w] = false;
        
        cin >> n;
        
        for (uint32_t i=0;i<n;i++) {
            cin >> w;
            
            exist[w] = true;
        }
        
        nComp = 0;
        repi(w,0,31)
            if (exist[w] && !used[w]) {
                nComp++;
                visit(w);
            }
        
        if (nComp > 1) {
            cout << "Error: Disconnected section of whacks s=" << s << endl;
            return 1;
        }
    }

    return 42;
}
