import java.util.ArrayList;
import java.util.Random;

public class WhackGen_John {

	public static boolean[][] adj = new boolean[31][31];
	public static Random rnd = new Random();
	public static int[] label = new int[31];
	public static int[] rotate1 = {0,26,21,11,20,25,27,12,6,19,30,22,13,7,2,1,10,18,24,29,28,14,3,5,17,23,15,8,4,9,16};
	public static int[] rotate2 = {0,2,3,4,5,1,7,8,9,10,6,12,13,14,15,16,17,18,19,20,11,22,23,24,25,21,27,28,29,30,26};
	
	public static void main(String[] args) {
		
		
		setAdj();
		label[1] = 1;
		int v = rndV();
		while (label[v] != 0)
			v = rndV();
		label[v] = 2;
//		System.out.println("labelling " + v + ": " + 2);
		v = rndV();
		while (label[v] != 0)
			v = rndV();
		label[v] = 3;
//		System.out.println("labelling " + v + ": " + 3);
		for(int count = 3;count <30; count++) {
			v = rndV();
			while (label[v] != 0)
				v = rndV();
			int w = findMarkedAdj(v);
			while (w == -1) {
				v = rndV();
				while (label[v] != 0)
					v = rndV();
				w = findMarkedAdj(v);
			}
			label[v] = label[w];
//			System.out.println("labelling " + v + ": " + label[w]);
		}
		ArrayList<Integer> a1 = new ArrayList<>();
		ArrayList<Integer> a2 = new ArrayList<>();
		ArrayList<Integer> a3 = new ArrayList<>();
		for(int i=1; i<=30; i++)
			switch(label[i]) {
			case 1: a1.add(i); break;
			case 2: a2.add(i); break;
			case 3: a3.add(i); break;
			default: System.out.println("bigtime error"); System.exit(-1);
			}
		
		outputSection(a1);
		outputSection(a2);
		outputSection(a3);
	}
	
	public static void outputSection(ArrayList<Integer> a)
	{
//		printSection(a);
		while (!a.contains(1)) {
			if (a.contains(2) || a.contains(3) || a.contains(4) || a.contains(5))
				a = rotate(a, rotate2);
			else
				a = rotate(a, rotate1);
		}
		printSection(a);
	}
	
	public static void printSection(ArrayList<Integer> a)
	{
		System.out.print(a.size());
		for(int v : a) {
			System.out.print(" " + v);
		}
		System.out.println();
	}
	public static ArrayList<Integer> rotate(ArrayList<Integer> a, int[] r)
	{
		ArrayList<Integer> newa = new ArrayList<>();
		for(int v : a) {
			newa.add(r[v]);
		}
		return newa;
	}
	
	public static int rndV()
	{
		return rnd.nextInt(30)+1;
	}
	
	public static int findMarkedAdj(int v)
	{
		int w = rndV()-1;
		for(int i=0; i<30; i++) {
			if (adj[v][w+1] && label[w+1] != 0)
				return w+1;
			w = (w+1)%30;
		}
		return -1;
	}
	public static void setAdj()
	{
		addEdge(1, 2);
		addEdge(1, 10);
		addEdge(1, 6);
		addEdge(2, 3);
		addEdge(2, 6);
		addEdge(2, 7);
		addEdge(3, 4);
		addEdge(3, 7);
		addEdge(3, 8);
		addEdge(4, 5);
		addEdge(4, 8);
		addEdge(4, 9);
		addEdge(5, 1);
		addEdge(5, 9);
		addEdge(5, 10);
		addEdge(6, 20);
		addEdge(6, 11);
		addEdge(7, 12);
		addEdge(7, 13);
		addEdge(8, 14);
		addEdge(8, 15);
		addEdge(9, 16);
		addEdge(9, 17);
		addEdge(10, 18);
		addEdge(10, 19);
		addEdge(11, 12);
		addEdge(11, 21);
		addEdge(12, 13);
		addEdge(12, 21);
		addEdge(13, 14);
		addEdge(13, 22);
		addEdge(14, 15);
		addEdge(14, 22);
		addEdge(15, 16);
		addEdge(15, 23);
		addEdge(16, 17);
		addEdge(16, 23);
		addEdge(17, 18);
		addEdge(17, 24);
		addEdge(18, 19);
		addEdge(18, 24);
		addEdge(19, 20);
		addEdge(19, 25);
		addEdge(20, 11);
		addEdge(20, 25);
		addEdge(21, 26);
		addEdge(21, 27);
		addEdge(22, 27);
		addEdge(22, 28);
		addEdge(23, 28);
		addEdge(23, 29);
		addEdge(24, 29);
		addEdge(24, 30);
		addEdge(25, 30);
		addEdge(25, 26);
		addEdge(26, 27);		
		addEdge(27, 28);		
		addEdge(28, 29);		
		addEdge(29, 30);		
		addEdge(30, 26);		

		
	}

	public static void addEdge(int v, int w)
	{
		adj[v][w] = adj[w][v] = true;
	}
}
