//
// Created by Robert Kramer on 11/30/21.
//

#include "Sampler.h"

Sampler::Sampler(uint32_t nEl) {

    elements = new uint32_t[nEl];

    nElements = nEl;

    for (uint32_t i=0;i<nEl;i++)
        elements[i] = i;

    rd = new std::random_device;

    mt = new std::mt19937((*rd)());
}

Sampler::~Sampler() {

    delete mt;
    delete rd;

    delete[] elements;
}

uint32_t Sampler::getSample() {
    uint32_t
        pos,
        val;

    if (nElements == 0)
        throw std::domain_error("No elements left to sample");

    std::uniform_int_distribution<>
        dis(0,nElements-1);

    pos = dis(*mt);
    val = elements[pos];

    nElements--;

    elements[pos] = elements[nElements];

    return val;
}
