import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;

public class BallOfWhacks_WA_John {

	public static Graph part1 = new Graph();
	public static Graph part2 = new Graph();
	public static Graph part3 = new Graph();

	public static boolean isoFound = false;
	
	public static void main(String [] args)
	{
		Scanner in = new Scanner(System.in);
		int size1, size2, size3;
		int [][] pieces = new int[3][30];

		size1 = in.nextInt();
		part1.buildGraph();
		for(int i=0; i<size1; i++) {
			pieces[0][i] = in.nextInt();
			part1.markUsed(pieces[0][i]);
		}
		size2 = in.nextInt();
		for(int i=0; i<size2; i++) {
			pieces[1][i] = in.nextInt();
			for(int j=0; j<i; j++)
				if (part1.isAdjacent(pieces[1][i], pieces[1][j])) {
					System.out.println("add edge " + pieces[1][i] + "," + pieces[1][j]);
					part2.addEdge(pieces[1][i], pieces[1][j]);
				}
		}
		if (size2 == 1)
			part2.vertices[1] = new Vertex(1);
		size3 = in.nextInt();
		for(int i=0; i<size3; i++) {
			pieces[2][i] = in.nextInt();
			for(int j=0; j<i; j++)
				if (part1.isAdjacent(pieces[2][i], pieces[2][j])) {
					System.out.println("add edge " + pieces[2][i] + "," + pieces[2][j]);
					part3.addEdge(pieces[2][i], pieces[2][j]);
				}
		}
		if (size3 == 1)
			part3.vertices[1] = new Vertex(1);

		if (size1+size2+size3 != 30)
			System.out.println("No");
		else {
			Map<Integer,Integer> map = new HashMap<>();
			if (findIso(part1, part2, part3, map, 1) ) {
				System.out.println("Yes");
			}
			else
				System.out.println("No");
		}
	}

	public static boolean findIso(Graph g, Graph h1, Graph h2, Map<Integer, Integer> map, int index)
	{
		Vertex w = null;
		if (index <= 30)
			w = h1.vertices[index];
		while (w == null && index < 30)
			w = h1.vertices[++index];
		if (w == null) {
			System.out.println("Isomorphism found");
			for(Integer hv : map.keySet()) {
				System.out.println(hv + "-->" + map.get(hv));
			}
			if (h2 == null)
				isoFound = true;
			return true;
		}
//		System.out.println("looking for mapping for vertex " + index);
		for (Vertex v : g.vertices) {
			if (v == null)
				continue;				// skip vertices[0]
			if (v.used)
				continue;
			boolean okMap = true;
			for(Integer hv : map.keySet()) {
				boolean gadj = g.isAdjacent(v.num, map.get(hv));
				boolean hadj = h1.isAdjacent(index, hv);
				if (gadj != hadj) {
					okMap = false;
					break;
				}
			}
			if (okMap) {
				v.used = true;
				map.put(index, v.num);
System.out.println("  " + index + " mapped to " + v.num);
				if (findIso(g, h1, h2, map, index+1)) {
					if (isoFound)
						return true;
					Map<Integer,Integer> map2 = new HashMap<>();
					if (findIso(g, h2, null, map2, 1))
						return true;
				}
				map.remove(index, v.num);
				v.used = false;
			}
		}
		return false;
	}
}

class Vertex
{
	public int num;
	public boolean used;
	public ArrayList<Vertex> adj = new ArrayList<>();

	public Vertex(int n)
	{
		num = n;
		used = false;
	}

	public void addEdge(Vertex v)
	{
		adj.add(v);
	}

}

class Graph
{
	public Vertex[] vertices = new Vertex[31];

	public void addEdge(int v, int w)
	{
		if (vertices[v] == null)
			vertices[v] = new Vertex(v);
		if (vertices[w] == null)
			vertices[w] = new Vertex(w);
		vertices[v].addEdge(vertices[w]);
		vertices[w].addEdge(vertices[v]);
	}

	public boolean isAdjacent(int v1, int v2)
	{
		for(Vertex w: vertices[v1].adj) {
			if (w.num == v2)
				return true;
		}
		return false;
	}

	public void markUsed(int v)
	{
		vertices[v].used = true;
	}

	public void buildGraph()
	{
		addEdge(1, 2);
		addEdge(1, 10);
		addEdge(1, 6);
		addEdge(2, 3);
		addEdge(2, 6);
		addEdge(2, 7);
		addEdge(3, 4);
		addEdge(3, 7);
		addEdge(3, 8);
		addEdge(4, 5);
		addEdge(4, 8);
		addEdge(4, 9);
		addEdge(5, 1);
		addEdge(5, 9);
		addEdge(5, 10);
		addEdge(6, 20);
		addEdge(6, 11);
		addEdge(7, 12);
		addEdge(7, 13);
		addEdge(8, 14);
		addEdge(8, 15);
		addEdge(9, 16);
		addEdge(9, 17);
		addEdge(10, 18);
		addEdge(10, 19);
		addEdge(11, 12);
		addEdge(11, 21);
		addEdge(12, 13);
		addEdge(12, 21);
		addEdge(13, 14);
		addEdge(13, 22);
		addEdge(14, 15);
		addEdge(14, 22);
		addEdge(15, 16);
		addEdge(15, 23);
		addEdge(16, 17);
		addEdge(16, 23);
		addEdge(17, 18);
		addEdge(17, 24);
		addEdge(18, 19);
		addEdge(18, 24);
		addEdge(19, 20);
		addEdge(19, 25);
		addEdge(20, 11);
		addEdge(20, 25);
		addEdge(21, 26);
		addEdge(21, 27);
		addEdge(22, 27);
		addEdge(22, 28);
		addEdge(23, 28);
		addEdge(23, 29);
		addEdge(24, 29);
		addEdge(24, 30);
		addEdge(25, 30);
		addEdge(25, 26);
		addEdge(26, 27);		
		addEdge(27, 28);		
		addEdge(28, 29);		
		addEdge(29, 30);		
		addEdge(30, 26);		
	}
}