#!/usr/bin/python3

import math


def cross(xx1,yy1,xx2,yy2):
    return xx1 * yy2 - xx2 * yy1


def project(xx,yy,rd):
    # length of OP
    vecLen = math.hypot(xx,yy)

    # length of OP'
    vecLenPrime = rd * rd / vecLen

    # ratio of |OP'| to |OP|
    ratio = vecLenPrime / vecLen

    return xx * ratio, yy * ratio
   
    
def solve(np):
    global coords
    
    total = 0

    xCur,yCur = project(coords[0][0],coords[0][1],r)

    for j in range(nVert):
        # loop over all points along the segment
        for i in range(np):
            # remember the previous point
            xPrev,yPrev = xCur,yCur

            # get the next point on the original rectangle
            x = coords[j][0] + (coords[j+1][0] - coords[j][0]) * i / np
            y = coords[j][1] + (coords[j+1][1] - coords[j][1]) * i / np
#        print(x,y)

            # project it into the circle
            xCur,yCur = project(x,y,r)
#        print(xCur,yCur)

            # add to the area
            total += cross(xPrev,yPrev,xCur,yCur)
#        print(total)

    # once more for the final point
    xPrev,yPrev = xCur,yCur

    xCur,yCur = project(coords[0][0],coords[0][1],r)

    total += cross(xPrev,yPrev,xCur,yCur)

    total = math.fabs(total)

    total /= 2

    return total


N_POINTS = 10000

(x0,y0,r) = list(map(int,input().split(' ')))

line = list(map(int,input().split(' ')))
nVert = line[0]
rawCoords = line[1:]

coords = []
for i in range(0,len(rawCoords),2):
    point =  [rawCoords[i]-x0,rawCoords[i+1]-y0]
    coords.append(point)

coords.append(coords[0])

pts = N_POINTS
cur = 1E-100
prev = 1E-200

while (cur - prev) / cur > 1E-6:
    prev = cur
    
    cur = solve(pts)
    
    pts *= 2
    
print(cur)
