import java.util.Scanner;

public class Downsizing_WA_John {

	public static void main(String[] args) {

		Scanner in = new Scanner(System.in);
		double r, x0, y0;

		x0 = in.nextDouble();
		y0 = in.nextDouble();
		r = in.nextDouble();		
		int npoints = in.nextInt();

		Point [] points = new Point[npoints];
		Point [] newpoints = new Point[npoints];
		for(int i=0; i<npoints; i++) {
			double x = in.nextDouble();
			double y = in.nextDouble();
			points[i] = new Point(x,y);
		}
		Point origin = new Point(0,0);
		// center circle at (0,0)
		for(int i=0; i<npoints; i++) {
			points[i].x -= x0;
			points[i].y -= y0;
		}

		for(int i=0; i<npoints; i++) {
			if (points[i].x != 0) {
				double m = points[i].y/points[i].x;
				double disc = Math.sqrt(1 + m*m);
				double sgnx = Math.abs(points[i].x)/points[i].x;
				double d = r*r/origin.dist(points[i]);
				double newx = d/disc*sgnx;
				newpoints[i] = new Point(newx, m*newx);
			}
			else {
				double newy = r*r/points[i].y;
				newpoints[i] = new Point(0, newy);
			}
			//			System.out.println(points[i] + "-->" + newpoints[i]);
		}
		double polyarea = calcPolygonArea(newpoints);
//		System.out.println("Initial poly area = " + polyarea);
		for(int i=0; i<npoints; i++) {
			polyarea += calcSectorArea(newpoints[i], newpoints[(i+1)%npoints], newpoints[(i+2)%npoints]);
			//			if (npoints > 3 && calcSectorArea(newpoints[i], newpoints[(i+1)%npoints], newpoints[(i+2)%npoints]) != calcSectorArea(newpoints[i], newpoints[(i+1)%npoints], newpoints[(i+3)%npoints]))
			//				System.out.println("Approach not working");
		}
		System.out.println(polyarea);

	}

	public static double calcPolygonArea(Point[] p)
	{
		int n = p.length;
		double area = 0.0;
		for(int i=0; i<n-1; i++) {
			area += (p[i+1].x-p[i].x)*(p[i+1].y+p[i].y);
		}
		area += (p[0].x - p[n-1].x)*(p[0].y+p[n-1].y);
		if (area < 0.0)
			return -area/2.0;
		else
			return area/2.0;
	}

	public static double calcSectorArea(Point p1, Point p2, Point p3)
	//
	// calculate circle center and radius for circle going through (0,0), p1 and p2
	// then use these to calculate sector area
	// if p3 inside circle then area is positive
	// otherwise area is negative
	{
		double denom = (p1.x*p2.y - p1.y*p2.x)*2.0;
		if (denom == 0.0) {
			return 0.0;
		}
		double p12 = p1.x*p1.x + p1.y*p1.y;
		double p22 = p2.x*p2.x + p2.y*p2.y;
		double xc = (p2.y*p12 - p1.y*p22)/denom;	// circle center
		double yc = (p1.x*p22 - p2.x*p12)/denom;
		double r = Math.sqrt(xc*xc + yc*yc);		// circle radius
		//		System.out.println("(" + xc + "," + yc + "), r = " + r);
		double a1 = Math.atan2(p1.y-yc, p1.x-xc);
		double a2 = Math.atan2(p2.y-yc, p2.x-xc);
		double angleDiff = Math.abs(a1-a2);
		if (angleDiff > Math.PI) {
			angleDiff = 2*Math.PI - angleDiff;
		}
		//System.out.println("Angle diff = " + angleDiff);
		double sectorArea = angleDiff*r*r/2.0;		// area of sector
		double c = p1.dist(p2);						// use Heron's formula for triangle area
		double s = (r+r+c)/2.0;
		double tarea = Math.sqrt(s*(s-r)*(s-r)*(s-c));
//		System.out.println("angle = " + angleDiff + ", sector area = " + sectorArea + ", triangle area = " + tarea);

		if (angleDiff < Math.PI) { 
			double newArea = sectorArea - tarea;
			if (p3.dist(new Point(xc, yc)) > r) {
//				System.out.println("subtracting " + newArea);
				return -newArea;
			}
			else {
//				System.out.println("adding " + newArea);
				return newArea;
			}
		}
		else {
			double newArea = sectorArea + tarea;
			if (p3.dist(new Point(xc, yc)) < r) {
//				System.out.println("subtracting " + newArea);
				return -newArea;
			}
			else {
//				System.out.println("adding " + newArea);
				return newArea;
			}
			
		}
	}
}

class Point {

	public double x, y;

	public Point(double x, double y)
	{
		this.x = x;
		this.y = y;
	}

	public double dist(Point p)
	{
		double dx = p.x-x;
		double dy = p.y-y;
		return Math.sqrt(dx*dx+dy*dy);
	}

	public String toString()
	{
		return "(" + x + "," + y + ")";
	}
}
 
