import java.util.Random;
import java.util.Scanner;

public class Downsizing_John {

	public static final boolean DEBUG = false;

	public static void main(String[] args) {

		Scanner in = new Scanner(System.in);
		double r, x0, y0;

		x0 = in.nextDouble();
		y0 = in.nextDouble();
		r = in.nextDouble();		
		int npoints = in.nextInt();

		Point [] points = new Point[npoints];
		Point [] newpoints = new Point[npoints];
		Point [] midpoints = new Point[npoints];
		for(int i=0; i<npoints; i++) {
			double x = in.nextDouble();
			double y = in.nextDouble();
			points[i] = new Point(x,y);
		}
		Point origin = new Point(0,0);
		// center circle at (0,0)
		for(int i=0; i<npoints; i++) {
			points[i].x -= x0;
			points[i].y -= y0;
		}

		for(int i=0; i<npoints; i++) {
			if (points[i].x != 0) {
				double m = points[i].y/points[i].x;
				double disc = Math.sqrt(1 + m*m);
				double sgnx = Math.abs(points[i].x)/points[i].x;
				double d = r*r/origin.dist(points[i]);
				double newx = d/disc*sgnx;
				newpoints[i] = new Point(newx, m*newx);
			}
			else {
				double newy = r*r/points[i].y;
				newpoints[i] = new Point(0, newy);
			}
			if (DEBUG) System.out.println(points[i] + "-->" + newpoints[i]);
		}
		for(int i=0; i<npoints; i++) {
			Point midpoint = new Point((points[i].x+points[(i+1)%npoints].x)/2.0, (points[i].y+points[(i+1)%npoints].y)/2.0);
			if (midpoint.x != 0) {
				double m = midpoint.y/midpoint.x;
				double disc = Math.sqrt(1 + m*m);
				double sgnx = Math.abs(midpoint.x)/midpoint.x;
				double d = r*r/origin.dist(midpoint);
				double newx = d/disc*sgnx;
				midpoints[i] = new Point(newx, m*newx);
			}
			else {
				double newy = r*r/midpoint.y;
				midpoints[i] = new Point(0, newy);
			}
			if (DEBUG) System.out.println(points[i] + "-->" + newpoints[i]);
		}

		double polyarea = 0.0;
		for(int i=0; i<npoints; i++) {
			double area = calcSectorArea(newpoints[i], newpoints[(i+1)%npoints], midpoints[i]);
/*
			double a1 = Math.atan2(points[i].y, points[i].x);
			double a2 = Math.atan2(points[(i+1)%npoints].y, points[(i+1)%npoints].x);
			double angleDiff = a1-a2;
			if (angleDiff > Math.PI)
				angleDiff -= 2*Math.PI;
			else if (angleDiff < -Math.PI)
				angleDiff += 2*Math.PI;
			if (angleDiff > 0)
				polyarea += area;
			else
				polyarea -= area;
*/
			Point currp = points[i];
			Point nextp = points[(i+1)%npoints];
			if (currp.x*nextp.y - currp.y*nextp.x > 0)	// look at z-component of cross-product to decide whether to
				polyarea -= area;						//   add or subtract
			else
				polyarea += area;
			
		}
		System.out.println(polyarea);

	}

	public static double calcSectorArea(Point p1, Point p2, Point pmid)
	//
	// calculate circle center and radius for circle going through (0,0), p1 and p2
	// then use these to calculate sector area
	// if p3 inside circle then area is positive
	// otherwise area is negative
	{
		double denom = (p1.x*p2.y - p1.y*p2.x)*2.0;
		if (denom == 0.0) {
			return 0.0;
		}
		double p12 = p1.x*p1.x + p1.y*p1.y;
		double p22 = p2.x*p2.x + p2.y*p2.y;
		double xc = (p2.y*p12 - p1.y*p22)/denom;	// circle center
		double yc = (p1.x*p22 - p2.x*p12)/denom;
		double r = Math.sqrt(xc*xc + yc*yc);		// circle radius
		if (DEBUG) System.out.println("(" + xc + "," + yc + "), r = " + r);
		double a1 = Math.atan2(p1.y-yc, p1.x-xc);
		double a2 = Math.atan2(p2.y-yc, p2.x-xc);
		double mid = Math.atan2(pmid.y-yc, pmid.x-xc);
		double angleDiff = Math.abs(a2-a1);

		//		if (angleDiff > Math.PI)
		//			angleDiff -= 2*Math.PI;
		//		else if (angleDiff < -Math.PI)
		//			angleDiff += 2*Math.PI;
		if (DEBUG) System.out.println("a1, a2, mid, angleDiff = " + a1 + "," + a2 + "," + mid + " " + angleDiff);
		double c = p1.dist(p2);						// use Heron's formula for triangle area
		double s = (r+r+c)/2.0;
		double tarea = Math.sqrt(s*(s-r)*(s-r)*(s-c));
		double sectorArea = 0.0;		// area of sector
		if (DEBUG) System.out.println("      sector area = " + sectorArea);
		if (useShortArc(a1, a2, mid)) {
			if (angleDiff > Math.PI)
				angleDiff = 2*Math.PI - angleDiff;
			sectorArea = Math.abs(angleDiff)*r*r/2.0;
			sectorArea -= tarea;
		}
		else {
			if (angleDiff < Math.PI)
				angleDiff = 2*Math.PI - angleDiff;
			sectorArea = Math.abs(angleDiff)*r*r/2.0;
			sectorArea += tarea;
		}
		if (DEBUG) System.out.println("      sector area = " + sectorArea);
		double r1 = Math.sqrt(p1.x*p1.x + p1.y*p1.y);
		double r2 = Math.sqrt(p2.x*p2.x + p2.y*p2.y);
		s = (r1+r2+c)/2.0;
		sectorArea += Math.sqrt(s*(s-r1)*(s-r2)*(s-c));
		if (DEBUG) System.out.println("      sector area = " + sectorArea);
		return sectorArea;
		/*
		double c = p1.dist(p2);						// use Heron's formula for triangle area
		double s = (r+r+c)/2.0;
		double tarea = Math.sqrt(s*(s-r)*(s-r)*(s-c));
		System.out.println("angle = " + angleDiff + ", sector area = " + sectorArea + ", triangle area = " + tarea + ", tri-sec = " + (tarea-sectorArea));
//		if (p3.dist(new Point(xc, yc)) > r)
//			return tarea - sectorArea;
//		else
			return sectorArea - tarea;
		 */
	}

	public static boolean useShortArc(double a1, double a2, double mid)
	/*
	 * checks where the translated midpoint angle lies between the translated endpoint angles of a segment
	 */
	{
		if (a1*a2 >= 0) {
			if ((mid > a1 && mid < a2) || (mid < a1 && mid > a2))
				return Math.abs(a1-a2) <= Math.PI;
			else
				return Math.abs(a1-a2) > Math.PI;
		}
		else {
			if (!((mid > a1 && mid > a2) || (mid < a1 && mid < a2)))
				return Math.abs(a1-a2) <= Math.PI;
			else
				return Math.abs(a1-a2) > Math.PI;
		}						
	}
}

class Point {

	public double x, y;

	public Point(double x, double y)
	{
		this.x = x;
		this.y = y;
	}

	public double dist(Point p)
	{
		double dx = p.x-x;
		double dy = p.y-y;
		return Math.sqrt(dx*dx+dy*dy);
	}

	public String toString()
	{
		return "(" + x + "," + y + ")";
	}
}