#include <iostream>
#include <cmath>
#include <iomanip>
#include <vector>

using namespace std;

#define REPI(ctr,start,limit) for (uint32_t ctr=(start);(ctr)<(limit);(ctr)++)

const int
    N_POINTS = 10000;
    
struct Point {
    explicit Point(double _x=0,double _y=0) { x = _x; y = _y; }

    Point &operator=(Point p) { x = p.x; y = p.y; return *this; }
    Point operator+(Point p) const { return Point(x+p.x,y+p.y); }
    Point operator-(Point p) const { return Point(x-p.x,y-p.y); }
    Point operator*(double r) const { return Point(x*r,y*r); }
    double operator*(Point p) const { return x * p.y - y * p.x; }

    [[nodiscard]] Point project(double r) const {
        double
            vecLen = hypot(x,y),
            ratio = r * r / (vecLen * vecLen);

        return Point(x*ratio,y*ratio);
    }

    double
        x,y;
};

int
    nVert;
double
    r;
Point
    p;
vector<Point>
    polygon;

double solve(int np) {
    Point
        cur,prev;
    double
        total = 0;

    cur = polygon[0].project(r);

    REPI(j,0,nVert)
        REPI(i,0,np) {
            prev = cur;

            p = polygon[j] + (polygon[j+1] - polygon[j]) * ((double)i / np);

            cur = p.project(r);

            total += prev * cur;
        }

    prev = cur;

    cur = polygon[0].project(r);

    total += prev * cur;

    if (total < 0)
        total = -total;

    return total / 2.0;
}

int main() {
    Point
        p0;
    double
        aPrev=1e-200,aCur=1e-100;
    int
        np = N_POINTS;

    cin >> p0.x >> p0.y >> r >> nVert;

    REPI(i,0,nVert) {
        cin >> p.x >> p.y;
        p = p - p0;
        polygon.push_back(p);
    }
    polygon.push_back(polygon[0]);
    
    do {
        aPrev = aCur;
        
        aCur = solve(np);
//        cout << aCur << endl;
        
        np *= 2;
    } while ((aCur - aPrev) / aCur > 1e-6);

    cout << setprecision(12) << aCur << endl;

    return 0;
}
