import java.util.ArrayList;
import java.util.Scanner;
import java.util.StringTokenizer;

// Noonerized input validator

public class JohnChecker
{
	public static final int MAX_VAL = (int)Math.pow(2,31) - 1;
	public static int exitCode = 42;

	public static void printError(int line, String msg)
	{
		System.out.println("ERROR Line " + line + ": " + msg);
		exitCode = -1;
	}

	public static void checkIntBounds(int x, int min, int max, String name, int nLines)
	{
		if (x < min || x > max)
			printError(nLines, "invalid " + name + " value: " + x);
	}

	public static void checkCharBounds(char x, char min, char max, String name, int nLines)
	{
		if (x < min || x > max)
			printError(nLines, "invalid " + name + " value: " + x);
	}

	public static void checkDoubleBounds(double x, double min, double max, String name, int nLines)
	{
		if (x < min || x > max)
			printError(nLines, "invalid " + name + " value: " + x);
	}

	public static int nextInt(StringTokenizer st)
	{
		return Integer.parseInt(st.nextToken());
	}

	public static void main(String [] args)
	{
		Scanner in = new Scanner(System.in);
		int val;
		String op;
		String line;
		int nLines=0;

		line = in.nextLine();
		nLines++;
		StringTokenizer st = new StringTokenizer(line);
		if (st.countTokens() != 5)
			printError(nLines, "number of tokens on line incorrect");

		val = nextInt(st);
		checkIntBounds(val, 1, MAX_VAL, "Value 1", nLines);
		op = st.nextToken();
		if (!op.equals("+") && !op.equals("*"))
			printError(nLines, "illegal operation: " + op);
		val = nextInt(st);
		checkIntBounds(val, 1, MAX_VAL, "Value 2", nLines);
		op = st.nextToken();
		if (!op.equals("="))
			printError(nLines, "illegal operation: " + op);
		val = nextInt(st);
		checkIntBounds(val, 1, MAX_VAL, "Value 3", nLines);

		if (in.hasNextLine())
			printError(nLines, "too many lines");
		System.exit(exitCode);
	}
}