# input checker for "noonerized spumbers"
# This doesn't do basic checks for range, spacing, syntax, etc -- see ctd file

import sys

[xs,op,ys,e,zs] = sys.stdin.readline().split()

x = int(xs)
y = int(ys)
z = int(zs)

# input should NOT be a valid equation:
if op == '*' and x*y==z:
  print("ERROR: true equation in input:",x,"*",y,"=",z)
  sys.exit(1)
elif op == '+' and x+y==z:
  print("ERROR: true equation in input:",x,"+",y,"=",z)
  sys.exit(1)

# Only one possible prefix swap will produce a valid equation, so
# check all possible swaps and make sure exactly one works:
xlen = len(xs)
ylen = len(ys)
zlen = len(zs)

count = 0
swaps = []

# Check all x-y swaps:
for i in range(1,xlen):
  x1 = xs[0:i]
  x2 = xs[i:]
  for j in range(1,ylen):
    y1 = ys[0:j]
    y2 = ys[j:]
    xt = int(y1+x2)
    yt = int(x1+y2)
    if (op == '+' and xt+yt==z) or (op == '*' and xt*yt==z):
      count += 1
      sol = (xt,yt,z)
      swaps.append((y1+":"+x2,x1+":"+y2,z))
# Check all x-z swaps:
for i in range(1,xlen):
  x1 = xs[0:i]
  x2 = xs[i:]
  for j in range(1,zlen):
    z1 = zs[0:j]
    z2 = zs[j:]
    xt = int(z1+x2)
    zt = int(x1+z2)
    if (op == '+' and xt+y==zt) or (op == '*' and xt*y==zt):
      count += 1
      sol = (xt,y,zt)
      swaps.append((z1+":"+x2,y,x1+":"+z2))
# Check all y-z swaps:
for i in range(1,ylen):
  y1 = ys[0:i]
  y2 = ys[i:]
  for j in range(1,zlen):
    z1 = zs[0:j]
    z2 = zs[j:]
    yt = int(z1+y2)
    zt = int(y1+z2)
    if (op == '+' and x+yt==zt) or (op == '*' and x*yt==zt):
      count += 1
      sol = (x,yt,zt)
      swaps.append((x,z1+":"+y2,y1+":"+z2))
if count == 1:
  sys.exit(42)
else:
  print("ERROR: Too many solutions:",swaps)
  sys.exit(1)

# Finally, make sure the (unique) solution fits inside an int:
(xu,yu,zu) = sol
if xu >= 2**31 or yu >= 2**31 or zu >= 2**31:
  print("ERROR: solution values > 2^31-1",sol)
