import java.util.ArrayList;
import java.util.Scanner;
import java.util.StringTokenizer;

//
// checker for Numble
//

public class JohnChecker
{
	public static final int MAX_D = 20;
	public static final int MAX_T = 10;
	public static int exitCode = 42;

	public static void printError(int line, String msg)
	{
		System.out.println("ERROR Line " + line + ": " + msg);
		exitCode = -1;
	}

	public static void checkIntBounds(int x, int min, int max, String name, int nLines)
	{
		if (x < min || x > max)
			printError(nLines, "invalid " + name + " value: " + x);
	}

	public static void checkCharBounds(char x, char min, char max, String name, int nLines)
	{
		if (x < min || x > max)
			printError(nLines, "invalid " + name + " value: " + x);
	}

	public static void checkDoubleBounds(double x, double min, double max, String name, int nLines)
	{
		if (x < min || x > max)
			printError(nLines, "invalid " + name + " value: " + x);
	}

	public static int nextInt(StringTokenizer st)
	{
		return Integer.parseInt(st.nextToken());
	}

	public static void main(String [] args)
	{
		Scanner in = new Scanner(System.in);
		int r, c, t;
		String line;
		int nLines=0;

		line = in.nextLine();
		nLines++;
		StringTokenizer st = new StringTokenizer(line);
		if (st.countTokens() != 2)
			printError(nLines, "number of values on line incorrect");

		r = nextInt(st);
		c = nextInt(st);
		checkIntBounds(r, 1, MAX_D, "r", nLines);
		checkIntBounds(c, 1, MAX_D, "c", nLines);

		char [][] board = new char[r][c];
		int startr=-1, startc=-1;
		int numrows = 0;
		while (in.hasNextLine() && numrows < r) {
			line = in.nextLine();
			nLines++;
			numrows++;
			st = new StringTokenizer(line);
			if (st.countTokens() != c) {
				printError(nLines, "Incorrect number of characters on line: " + st.countTokens());
			}
			int numi = st.countTokens();
			for(int i=0; i<numi; i++) {
				String s = st.nextToken();
				if (s.length() != 1) {
					printError(nLines, "Bad value in grid: " + s);
				}
				char ch = s.charAt(0);
				if (Character.isDigit(ch)) {
					board[numrows-1][i] = ch;
					startr = numrows-1;
					startc = i;
				}
				else if (ch != '-' && ch != 'd' && ch != 't' && ch != 'D' && ch != 'T') {
					printError(nLines, "illegal board character: " + ch);
				}
			}
		}
		if (numrows != r)
			printError(nLines, "too few rows: " + numrows);
		else if (startr == -1) {
			printError(nLines, "no digit on the board");
		}
		else {
			checkBoard(board, startr, startc, nLines);
		}


		line = in.nextLine();
		nLines++;
		st = new StringTokenizer(line);
		if (st.countTokens() != 1)
			printError(nLines, "number of values on line incorrect");
		t = nextInt(st);
		checkIntBounds(t, 1, MAX_T, "t", nLines);
		if (!in.hasNextLine()) {
			printError(nLines, "no tiles given");
		}
		line = in.nextLine();
		nLines++;
		st = new StringTokenizer(line);
		if (st.countTokens() != t)
			printError(nLines, "incorrect number of tiles on line: " + st.countTokens());
		int numi = st.countTokens();
		for(int i=0; i<numi; i++) {
			String s = st.nextToken();
			if (s.length() != 1) {
				printError(nLines, "illegal tile value: " + s);
			}
			char ch = s.charAt(0);
			if (!Character.isDigit(ch)) {
				printError(nLines, "illegal tile value: " + ch);
			}
		}
		if (in.hasNextLine())
			printError(nLines, "extra line at end of file");
		System.exit(exitCode);
	}

	public static void checkBoard(char[][] board, int startr, int startc, int nLines)
	{
		final int NOSEQ = 0;
		final int START = 1;
		final int INC = 2;
		final int DEC = 3;
		// check for increasing/decreasing sequences in rows
		for(int r=0; r<board.length; r++) {
			int mode = NOSEQ;
			for(int c=0; c<board[0].length; c++) {
				char ch = board[r][c];
				if (Character.isDigit(ch)) {
					switch (mode) {
					case NOSEQ: mode = START; break;
					case START:
						if (board[r][c-1] < ch)
							mode = INC;
						else if (board[r][c-1] > ch)
							mode = DEC;
						break;
					case INC:
						if (board[r][c-1] > ch)
							printError(nLines, "invalid sequence found in row " + r);
						break;
					case DEC:
						if (board[r][c-1] < ch)
							printError(nLines, "invalid sequence found in row " + r);
						break;
					}
				}
				else
					mode = NOSEQ;
			}
		}
		// check for increasing/decreasing sequences in columns
		for(int c=0; c<board[0].length; c++) {
			int mode = NOSEQ;
			for(int r=0; r<board.length; r++) {
				char ch = board[r][c];
				if (Character.isDigit(ch)) {
					switch (mode) {
					case NOSEQ: mode = START; break;
					case START:
						if (board[r-1][c] < ch)
							mode = INC;
						else if (board[r-1][c] > ch)
							mode = DEC;
						break;
					case INC:
						if (board[r-1][c] > ch)
							printError(nLines, "invalid sequence found in col " + c);
						break;
					case DEC:
						if (board[r-1][c] < ch)
							printError(nLines, "invalid sequence found in col " + c);
						break;
					}
				}
				else
					mode = NOSEQ;
			}
		}
		// check for connected sequences of digits
		checkConnected(board, startr, startc);
		for(int r=0; r<board.length; r++) {
			for(int c=0; c<board[0].length; c++) {
				if (Character.isDigit(board[r][c]))
					printError(nLines, "digit sequences not connected: " + r + "," + c + " " + board[r][c]);
			}
		}
	}

	public static void checkConnected(char[][] board, int r, int c)
	{
		if (!Character.isDigit(board[r][c]))
			return;
		board[r][c] = ' ';
		if (r > 0)
			checkConnected(board, r-1, c);
		if (r < board.length-1)
			checkConnected(board, r+1, c);
		if (c > 0)
			checkConnected(board, r, c-1);
		if (c < board[0].length-1)
			checkConnected(board, r, c+1);
	}
}