import java.util.ArrayList;
import java.util.Scanner;
import java.util.StringTokenizer;

// checker for Pinned Files

public class JohnChecker
{
	public static final int MAX_PU = 100;

	public static int exitCode = 42;

    public static void printError(int line, String msg)
	{
		System.out.println("ERROR Line " + line + ": " + msg);
		exitCode = -1;
	}

    public static void checkIntBounds(int x, int min, int max, String name, int nLines)
    {
        if (x < min || x > max)
            printError(nLines, "invalid " + name + " value: " + x);
    }

    public static void checkCharBounds(char x, char min, char max, String name, int nLines)
    {
        if (x < min || x > max)
            printError(nLines, "invalid " + name + " value: " + x);
    }

    public static void checkDoubleBounds(double x, double min, double max, String name, int nLines)
    {
        if (x < min || x > max)
            printError(nLines, "invalid " + name + " value: " + x);
    }

    public static int nextInt(StringTokenizer st)
    {
        return Integer.parseInt(st.nextToken());
    }

    public static void main(String [] args)
	{
		Scanner in = new Scanner(System.in);
		int p, u;
		String line;
		int nLines=0;

        line = in.nextLine();
        nLines++;
        StringTokenizer st = new StringTokenizer(line);
        if (st.countTokens() != 2)
            printError(nLines, "number of values on line incorrect");
        p = nextInt(st);
        u = nextInt(st);
        checkIntBounds(p, 0, MAX_PU, "p", nLines);
        checkIntBounds(u, 0, MAX_PU, "u", nLines);
        checkIntBounds(p+u, 1, MAX_PU, "p+u", nLines);
        boolean [] found = new boolean[p+u+1];
        line = in.nextLine();
        nLines++;
        st = new StringTokenizer(line);
        if (st.countTokens() != p+u)
            printError(nLines, "number of files incorrect");
        for(int i=0; i<p+u; i++) {
        	int val = nextInt(st);
        	checkIntBounds(val, 1, p+u, "file"+val, nLines);
        	if (val<1 || val > p+u)
        		continue;
        	if (found[val]) {
        		printError(nLines, "repeat file number: " + val);
        	}
        	found[val] = true;
        }
        line = in.nextLine();
        nLines++;
        st = new StringTokenizer(line);
        if (st.countTokens() != 2)
            printError(nLines, "number of values on line incorrect");
        p = nextInt(st);
        u = nextInt(st);
        checkIntBounds(p, 0, MAX_PU, "p", nLines);
        checkIntBounds(u, 0, MAX_PU, "u", nLines);
        checkIntBounds(p+u, 1, MAX_PU, "p+u", nLines);
        found = new boolean[p+u+1];
        line = in.nextLine();
        nLines++;
        st = new StringTokenizer(line);
        if (st.countTokens() != p+u)
            printError(nLines, "number of files incorrect");
        for(int i=0; i<p+u; i++) {
        	int val = nextInt(st);
        	checkIntBounds(val, 1, p+u, "file"+val, nLines);
        	if (val<1 || val > p+u)
        		continue;
        	if (found[val]) {
        		printError(nLines, "repeat file number: " + val);
        	}
        	found[val] = true;
        }
 
        if (in.hasNextLine())
        		printError(nLines, "too many lines");
        System.exit(exitCode);
	}
}
