import java.util.*;

// abstract checker

public class JohnChecker
{
	public static final int MAXD = 50;

	public static int exitCode = 42;

    public static void printError(int line, String msg)
	{
		System.out.println("ERROR Line " + line + ": " + msg);
		exitCode = -1;
	}

    public static void checkIntBounds(int x, int min, int max, String name, int nLines)
    {
        if (x < min || x > max)
            printError(nLines, "invalid " + name + " value: " + x);
    }

    public static void checkCharBounds(char x, char min, char max, String name, int nLines)
    {
        if (x < min || x > max)
            printError(nLines, "invalid " + name + " value: " + x);
    }

    public static void checkDoubleBounds(double x, double min, double max, String name, int nLines)
    {
        if (x < min || x > max)
            printError(nLines, "invalid " + name + " value: " + x);
    }

    public static int nextInt(StringTokenizer st)
    {
        return Integer.parseInt(st.nextToken());
    }

    public static void main(String [] args)
	{
		Scanner in = new Scanner(System.in);
		int n, m;
		String line;
		int nLines=0;

        line = in.nextLine();
        nLines++;
        StringTokenizer st = new StringTokenizer(line);
        if (st.countTokens() != 2)
            printError(nLines, "number of values on line incorrect");
        n = nextInt(st);
        m = nextInt(st);
        checkIntBounds(n, 1, MAXD, "n", nLines);
        checkIntBounds(m, 1, MAXD, "m", nLines);

        int numRows = 0;
        ArrayList<Integer> vals = new ArrayList<>();
        while (in.hasNextLine()) {
        	line = in.nextLine();
        	nLines++;
        	if (++numRows > n) {
        		printError(nLines, "too many lines");
        		break;
        	}
        	st = new StringTokenizer(line);
        	if (st.countTokens() != m) {
        		printError(nLines, "too few values: " + m);
        	}
        	for(int c=0; c<st.countTokens(); c++) {
        		int val = nextInt(st);
        		if (val == 0 || val < -1)
            		printError(nLines, "illegal value: " + val);
        		if (val != -1) {
        			if (vals.contains(val))
                		printError(nLines, "repeat value: " + m);
        			else
        				vals.add(val);
        		}
        	}
        }
        System.exit(exitCode);
	}
}
