import java.util.ArrayList;
import java.util.Scanner;
import java.util.StringTokenizer;

//
// checker for Tomb Hater
//

public class JohnChecker
{
	public static final int MAX_D = 50;
	public static final int MAX_G = 50;
	public static final int MAX_G_LEN = 50;
	public static int exitCode = 42;

	public static void printError(int line, String msg)
	{
		System.out.println("ERROR Line " + line + ": " + msg);
		exitCode = -1;
	}

	public static void checkIntBounds(int x, int min, int max, String name, int nLines)
	{
		if (x < min || x > max)
			printError(nLines, "invalid " + name + " value: " + x);
	}

	public static void checkCharBounds(char x, char min, char max, String name, int nLines)
	{
		if (x < min || x > max)
			printError(nLines, "invalid " + name + " value: " + x);
	}

	public static void checkDoubleBounds(double x, double min, double max, String name, int nLines)
	{
		if (x < min || x > max)
			printError(nLines, "invalid " + name + " value: " + x);
	}

	public static int nextInt(StringTokenizer st)
	{
		return Integer.parseInt(st.nextToken());
	}

	public static void main(String [] args)
	{
		Scanner in = new Scanner(System.in);
		int m, n, k;
		String line;
		int nLines=0;

		line = in.nextLine();
		nLines++;
		StringTokenizer st = new StringTokenizer(line);
		if (st.countTokens() != 3)
			printError(nLines, "number of values on line incorrect");

		m = nextInt(st);
		n = nextInt(st);
		k = nextInt(st);
		checkIntBounds(m, 1, MAX_D, "m", nLines);
		checkIntBounds(n, 1, MAX_D, "n", nLines);
		checkIntBounds(k, 1, MAX_G, "k", nLines);

		int numrows = 0;
		while (in.hasNextLine() && numrows < m) {
			line = in.nextLine();
			nLines++;
			numrows++;
			st = new StringTokenizer(line);
			if (st.countTokens() != n) {
				printError(nLines, "Incorrect number of characters on line: " + st.countTokens());
			}
			int numi = st.countTokens();
			for(int i=0; i<numi; i++) {
				String s = st.nextToken();
				if (s.length() != 1) {
					printError(nLines, "Bad value in grid: " + s);
				}
				checkCharBounds(s.charAt(0), 'A', 'Z', "grid character", nLines);
			}
		}
		if (numrows != m)
			printError(nLines, "too few frid lines: " + numrows);
		numrows = 0;
		while (in.hasNextLine()) {
			line = in.nextLine();
			nLines++;
			numrows++;
			st = new StringTokenizer(line);
			if (st.countTokens() != 1)
				printError(nLines, "more than one glyph on line");
			int length = line.length();
			checkIntBounds(length, 1, MAX_G_LEN, "glyph length", nLines);
			for(int i=0; i<length; i++)
				checkCharBounds(line.charAt(i), 'A', 'Z', "glyph character", nLines);
		}
		if (numrows != k)
			printError(nLines, "incorrect number of glyphs: " + numrows);
		System.exit(exitCode);
	}
}