import java.util.Scanner;
import java.util.Queue;
import java.util.LinkedList;

public class AMazingPuzzle_John {

	public static final String DIRECTIONS = "NESW";
	public static final int NORTH = 0;
	public static final int EAST = 1;
	public static final int SOUTH = 2;
	public static final int WEST = 3;
	public static final int[] CDIRS = {0,1,0,-1};
	public static final int[] RDIRS = {1,0,-1,0};

	public static Node[] graph;

	public static void main(String[] args) {

		int c, r, e, initc1, initr1, initc2, initr2, initd1, initd2;
		Scanner in = new Scanner(System.in);

		c = in.nextInt();
		r = in.nextInt();
		e = in.nextInt()-1;
		initc1 = in.nextInt()-1;
		initr1 = in.nextInt()-1;
		initd1 = DIRECTIONS.indexOf(in.next().charAt(0));
		initc2 = in.nextInt()-1;
		initr2 = in.nextInt()-1;
		initd2 = DIRECTIONS.indexOf(in.next().charAt(0));

		boolean [][][] adj = new boolean[c][r][4];
		for(int i=0; i<c; i++)
			for(int j=0; j<r; j++)
				for(int k=0; k<4; k++)
					adj[i][j][k] = true;		// true ==> can move in that direction k from [i,j]
		for(int i=0; i<c; i++)
			adj[i][0][SOUTH] = adj[i][r-1][NORTH] = false;		// 0 - North, 2 - South
		for(int j=0; j<r; j++) {
			adj[0][j][WEST] = adj[c-1][j][EAST] = false;		// 1 - East, 3 - West
		}
		adj[e][0][SOUTH] = true;							// exit square

		int n = in.nextInt();
		for(int i=0; i<n; i++) {
			int wc = in.nextInt()-1;
			int wr = in.nextInt()-1;
			adj[wc][wr][NORTH] = adj[wc][wr+1][SOUTH] = false;
		}
		n = in.nextInt();
		for(int i=0; i<n; i++) {
			int wc = in.nextInt()-1;
			int wr = in.nextInt()-1;
			adj[wc][wr][EAST] = adj[wc+1][wr][WEST] = false;
		}
		// build search graph
		graph = new Node[c*r*c*r + 2*c*r + 1];
		for(int i=0; i<c*r*c*r; i++) {
			graph[i] = new Node(i, c, r);
		}
		for(int i=0; i<r*c; i++) {
			int j = i + c*r*c*r;
			graph[j] = new Node(e,-1,i/r,i%r);
		}
		for(int i=0; i<r*c; i++) {
			int j = i + c*r*c*r + c*r;
			graph[j] = new Node(i/r,i%r, e, -1);
		}
		graph[c*r*c*r + 2*c*r] = new Node(e,-1,e,-1);

		for(int i=0; i<c*r*c*r; i++) {
			int d1 = initd1;
			int d2 = initd2;
			int c1 = graph[i].c1;
			int r1 = graph[i].r1;
			int c2 = graph[i].c2;
			int r2 = graph[i].r2;
			if (c1 == c2 && r1 == r2)
				continue;
			for(int d=0; d<4; d++) {
				if(adj[c1][r1][d1] || adj[c2][r2][d2]) {
					int newc1 = c1;
					int newr1 = r1;
					int newc2 = c2;
					int newr2 = r2;
					if (adj[c1][r1][d1]) {
						newc1 += CDIRS[d1];
						newr1 += RDIRS[d1];
					}
					if (adj[c2][r2][d2]) {
						newc2 += CDIRS[d2];
						newr2 += RDIRS[d2];
					}
					if (newc1 != newc2 || newr1 != newr2) {
						int index;
						if (newr1 == -1)
							index = r*c*r*c + newc2*r + newr2;
						else if (newr2 == -1)
							index = r*c*r*c + r*c + newc1*r + newr1;
						else
							index = newc1*r*c*r + newr1*c*r + newc2*r + newr2;
						graph[i].addAdjacent(graph[index]);
					}
				}
				d1 = (d1+1)%4;
				d2 = (d2+1)%4;
			}
		}
		for(int i=0; i<c*r; i++) {
			int j = i+c*r*c*r;
			int c2 = graph[j].c2;		// c1,r1 = e,-1
			int r2 = graph[j].r2;
			for(int d=0; d<4; d++) {
				if (adj[c2][r2][d]) {					
					int newc2 = c2+CDIRS[d];
					int newr2 = r2+RDIRS[d];
					int index;
					if (newr2 == -1)
						index = c*r*c*r + 2*c*r;
					else
						index = c*r*c*r + newc2*r + newr2;
					graph[j].addAdjacent(graph[index]);
				}
			}
		}
		for(int i=0; i<c*r; i++) {
			int j = i+c*r*c*r+c*r;
			int c1 = graph[j].c1;		// c2,r2 = e,-1
			int r1 = graph[j].r1;
			for(int d=0; d<4; d++) {
				if (adj[c1][r1][d]) {					
					int newc1 = c1+CDIRS[d];
					int newr1 = r1+RDIRS[d];
					int index;
					if (newr1 == -1)
						index = c*r*c*r + 2*c*r;
					else
						index = c*r*c*r +c*r + newc1*r + newr1;
					graph[j].addAdjacent(graph[index]);
				}
			}
		}
//		printGraph(graph);
		Node exit = bfs(initc1*r*c*r + initr1*c*r + initc2*r + initr2, e);
		System.out.println(exit.dist + " " + exit.bumps);

	}

	public static Node bfs(int start, int exit)
	{
		Queue<Node> q = new LinkedList<>();
		graph[start].dist = 0;
		q.add(graph[start]);
		while(!q.isEmpty()) {
//printQueue(q);
			Node node = q.remove();
			if (node.c1 == exit && node.r1 == -1 && node.c2 == exit && node.r2 == -1)
				return node;
			for(NodeList nl = node.adj; nl != null; nl = nl.next) {
//				int savedist = nl.node.dist;
//				int savebumps = nl.node.bumps;
				int newDist = node.dist+1;
				int newBumps = node.bumps;
				if (node.c1 == nl.node.c1 && node.r1 == nl.node.r1 && node.r1 >= 0)
					newBumps++;
				else if (node.c2 == nl.node.c2 && node.r2 == nl.node.r2 && node.r2 >= 0)
					newBumps++;
				if (nl.node.dist == -1 || newDist < nl.node.dist || (newDist == nl.node.dist && newBumps < nl.node.bumps)) {
					int save = nl.node.dist;
					nl.node.dist = newDist;
					nl.node.bumps = newBumps;
					if (save == -1)
						q.add(nl.node);
				}
			}
		}
		return null;			// should never happen...but you never know
	}
	public static void printGraph(Node [] graph)
	{
		for(int i=0; i<graph.length; i++) {
			if (graph[i] != null) {
				System.out.print(graph[i]+" -->");
				for(NodeList nl = graph[i].adj; nl != null; nl = nl.next) {
					System.out.print(nl.node);
				}
				System.out.println();
			}
		}
	}
	
	public static void printQueue(Queue<Node> q)
	{
		Object [] a = q.toArray();
		for(int i=0; i<a.length; i++) {
			System.out.print((Node)a[i] + " ");
		}
		System.out.println();
	}
}

class Node
{
	int c1, r1, c2, r2;			// these may not be necessary
	int dist, bumps;
	NodeList adj;

	public Node(int i, int c, int r)
	{
		r2 = i % r;
		i /= r;
		c2 = i % c;
		i /= c;
		r1 = i % r;
		c1 = i / r;
		adj = null;
		dist = -1;
		bumps = 0;
	}

	public Node(int c1, int r1, int c2, int r2)
	{
		this.c1 = c1;
		this.r1 = r1;
		this.c2 = c2;
		this.r2 = r2;
		adj = null;
		dist = -1;
		bumps = 0;
	}

	public void addAdjacent(Node node)
	{
		adj = new NodeList(node, adj);
	}

	public String toString()
	{
		return "["+c1+"," + r1 + " " + c2 + "," + r2 + "] " + dist + "," + bumps;
	}
}

class NodeList
{
	Node node;
	NodeList next;

	public NodeList(Node node, NodeList next)
	{
		this.node = node;
		this.next = next;
	}
}