#include <iostream>

using namespace std;

#define REPI(ctr,start,limit) for (uint32_t ctr=(start);(ctr)<(limit);(ctr)++)

const string
    RANKS = "A23456789TJQK";

uint64_t iFact(uint64_t n) {
    uint64_t
        ans = 1;

    REPI(i,1,n+1)
        ans *= i;

    return ans;
}

uint64_t choose(uint64_t n,uint64_t k) {

    if (k > n)
        return 0;

    return iFact(n) / (iFact(k) * iFact(n-k));
}

uint64_t try15(uint32_t cc,uint32_t s,uint64_t nPerRank[]) {
    uint64_t
        temp = 0;

    if (s == 0)
        return 2;
    if (cc > 9)
        return 0;
    for (uint32_t ii=0;ii<=nPerRank[cc] && ii * (1 + cc) <= s;ii++)
        temp += choose(nPerRank[cc],ii) * try15(cc+1,s-ii*(1+cc), nPerRank);
    return temp;
}

int main() {
    uint64_t
        nCards,
        score=0,
        nPerRank[13]={0},
        tmp, j, runLen;
    char
        ch;

    cin >> nCards;

    REPI(i,0,nCards) {
        cin >> ch;
        nPerRank[RANKS.find(ch)]++;
    }

    // pairs
    REPI(i,0,13)
        score += nPerRank[i] * (nPerRank[i] - 1);

    for (uint32_t i=0;i<=10;) {
        if (nPerRank[i] > 0 && nPerRank[i+1] > 0 && nPerRank[i+2] > 0) {
            tmp = 1;
            j = i;
            runLen = 0;
            while (j < 13 && nPerRank[j] > 0) {
                tmp *= nPerRank[j];
                j++;
                runLen++;
            }
            score += tmp * runLen;
            i += runLen;
        } else
            i++;
    }

    nPerRank[9] += nPerRank[10] + nPerRank[11] + nPerRank[12];
    score += try15(0,15,nPerRank);

    cout << score << endl;

    return 0;
}
