#!/usr/bin/python3

"""
Try all combinations or n1,n2,n3 satisfying the multiplicative conditions.
author: Finn Lidbetter
"""

import math
from sys import stdin
import random

tokens = stdin.readline().split(' ')
r = int(tokens[0])
s = int(tokens[1])
h = int(tokens[2])

circumference = 2 * math.pi * r
period = circumference / s
days = period / h
days_down = days // 1
days_up = days_down + 1
if days_down == days:
    days_up = days
best_diff = 1
best = 0, 0, 0
valid_tuples = []
for n1 in range(2, 1001):
    for n2 in range(2*n1, 1001, n1):
        for n3 in range(2*n2, 1001, n2):
            valid_tuples.append((n1,n2,n3))
random.shuffle(valid_tuples)
for n1,n2,n3 in valid_tuples:
    term = (1/n1) - (1/n2) + (1/n3)
    diff = min(abs(days - (days_down + term)), abs(days - (days_up - term)))
    if diff < best_diff:
        best_diff = diff
        best = n1, n2, n3
best_n1, best_n2, best_n3 = best
print(f'{best_n1} {best_n2} {best_n3}')
