#!/usr/bin/env python3
"""
Example output validator template for use with Kattis problemtools.

Write your own 'validate' function and modify the read_input and read_output
functions to parse what is read.
"""

import math
from sys import stdin,argv


def report_good_answer():
    exit(42)

def report_wrong_answer(message, verdict_file):
    print(message, file=verdict_file)
    exit(43)

def is_eof(input_stream):
    line = input_stream.readline()
    if line != "":
        return False
    return True


def read_input(input_stream, verdict_file):
    try:
        the_input = input_stream.readline()
        tokens = the_input.split(' ')
        r = int(tokens[0])
        s = int(tokens[1])
        h = int(tokens[2])
        # Maybe do some parsing here and convert the_input into a more useful format.
    except Exception as e:
        report_wrong_answer(
            'Input could not be read. {}'.format(str(e)), verdict_file)
    return r, s, h


def read_output(input_stream, verdict_file):
    try:
        line = input_stream.readline()
        tokens = line.split(' ')
        n1 = int(tokens[0])
        n2 = int(tokens[1])
        n3 = int(tokens[2])
    except Exception as e:
        report_wrong_answer(
            'Output could not be read: {}'.format(str(e)), verdict_file)
    return n1, n2, n3


def gcd(a, b):
    if b == 0:
        return a
    return gcd(b, a%b)

def validate(the_input, the_output, judge_output):
    """Implement this function according to your use case."""
    if judge_output is not None:
        jn1, jn2, jn3 = judge_output
        n1, n2, n3 = the_output
        if n1 < 1 or n1 > 1000 or n2 < 1 or n2 > 1000 or n3 < 1 or n3 > 1000:
            return False, "n1, n2, or n3 is not in the range [1,1000]"
        if n2<=n1 or n3<=n1 or n3<=n2:
            return False, "n1,n2,n3 do not satisfy n1<n2<n3"
        if n2%n1 != 0:
            return False, "n1 does not divide n2"
        if n3%n2 != 0:
            return False, "n2 does not divide n3"
        judge_num = jn2*jn3 - jn1*jn3 + jn1*jn2
        judge_denom = jn1*jn2*jn3
        judge_gcf = gcd(abs(judge_num), judge_denom)
        judge_num = judge_num / judge_gcf
        judge_denom = judge_denom / judge_gcf
        c_num = n2*n3 - n1*n3 + n1*n2
        c_denom = n1*n2*n3
        c_gcf = gcd(abs(c_num), c_denom)
        c_num = c_num / c_gcf
        c_denom = c_denom / c_gcf
        if c_num != judge_num or c_denom != judge_denom:
            return False, "Fractions are not equal"
        return True, "Output is valid!"
    else:
        r,s,h = the_input

        circumference = 2 * math.pi * r
        period = circumference / s
        days = period / h
        days_down = days // 1
        days_up = days_down + 1
        if days_down == days:
            days_up = days
        best_diff = 1
        best = 0, 0, 0
        for n1 in range(2, 1001):
            for n2 in range(2*n1, 1001, n1):
                for n3 in range(2*n2, 1001, n2):
                    term = (1/n1) - (1/n2) + (1/n3)
                    diff = min(abs(days - (days_down + term)), abs(days - (days_up - term)))
                    if diff < best_diff:
                        best_diff = diff
                        best = n1, n2, n3
        best_n1, best_n2, best_n3 = best

        output_n1, output_n2, output_n3 = the_output
        if output_n1 != best_n1 or output_n2 != best_n2 or output_n3 != best_n3:
            return False, "Judge answer is not the smallest n1,n2,n3 tuple giving the best approximation."
    return True, "Output is valid!"
    
      
with open(argv[1],"r") as filein, open(argv[2],"r") as fileans, open(argv[3]+"judgemessage.txt","w") as verdict_file:
        
    print("Reading input")
    the_input = read_input(filein, verdict_file)
    print("Finished reading input")

    print("Reading judge output")
    judge_output = read_output(fileans, verdict_file)
    print("Finished reading judge output")
    judge_success, judge_err = validate(the_input, judge_output, None)
    if not judge_success:
        report_wrong_answer('JUDGE ERROR: %s' % judge_err,
                            verdict_file)
    print("Reading contestant output")
    contestant_output = read_output(stdin, verdict_file)
    print("Finished reading contestant output")
    contestant_success, contestant_err = validate(the_input, contestant_output, judge_output)
    if not contestant_success:
        print(f"Contestant error: {contestant_err}")
        report_wrong_answer('Validation of contestant output failed: %s' % contestant_err, 
                            verdict_file)
    if not is_eof(stdin):
        report_wrong_answer('Too much output', verdict_file)
    report_good_answer()
