#include <iostream>
#include <random>

using namespace std;

#define REPI(ctr,start,limit) for (uint32_t ctr=(start);(ctr)<(limit);(ctr)++)

const uint32_t
  MAX_BASES = 50000;

int main() {
  random_device
    rd;
  mt19937
    mt(rd());
  uniform_int_distribution<>
    dis(0,3),
    lenDis(1,MAX_BASES);
  uint32_t
    nBases = lenDis(mt);
/*  
  REPI(i,0,MAX_BASES)
//    cout << 'T';
    cout << "ATGC"[dis(mt)];
  cout << "\n" << (MAX_BASES / 2) << endl;
  
  REPI(i,1,MAX_BASES / 2 + 1)
    cout << i << ' ' << (i+MAX_BASES/2) << endl;
  */
  
  REPI(i,0,nBases)
    cout << "ATGC"[dis(mt)];
  cout << "\n10" << endl;
  REPI(i,0,10) {
    uint32_t
      s,e;
    uniform_int_distribution<>
      boundDis(1,nBases);
    
    do {
      s = boundDis(mt);
      e = boundDis(mt);
    } while (s > e);
    
    cout << s << ' ' << e << endl;
  }
  
  return 0;
}

