#!/usr/bin/env python3

# Check to make sure steam cloud emerges between x0 and xn
# Does not do basic checks on input bounds, etc.

import sys
import math

class Pt:
  def __init__(self,x,y):
    self.x = x
    self.y = y

# distance formula
def dist(p1,p2):
  return math.sqrt((p2.x-p1.x)*(p2.x-p1.x)+(p2.y-p1.y)*(p2.y-p1.y))

# return true iff p3 is strictly between p1 and p2 (p1, p2, p3 are collinear)
def btwn(p1,p2,p3):
  d1 = dist(p1,p3)
  d2 = dist(p3,p2)
  d = dist(p1,p2)
  return d1 > 0 and d2 > 0 and abs(d1+d2-d) < 1e-9

# return true iff line p1--p2 intersects segment p3--p4 at a point
# strictly between p3 and p4 (no endpoint intersection allowed)
def inter(p1,p2,p3,p4):
    a1 = p1.y-p2.y
    b1 = p2.x-p1.x
    c1 = p1.x*a1+p1.y*b1
        
    a2 = p3.y-p4.y
    b2 = p4.x-p3.x
    c2 = p3.x*a2+p3.y*b2
        
    det = a1*b2-a2*b1
    if det == 0: 
      return None
    x = (c1*b2-c2*b1)/det
    y = (a1*c2-a2*c1)/det
    return btwn(p3,p4,Pt(x,y))


line = list(map(int,sys.stdin.readline().split()))
n = line[0]
x = [None for i in range(n+1)]
y = [None for i in range(n+1)]
p = [None for i in range(n+1)]
for i in range(n+1):
  x[i] = line[2*i+1]
  y[i] = line[2*i+2]
  p[i] = Pt(x[i],y[i])
[cx,sx,sy,rad,dx,dy,vel] = list(map(int,sys.stdin.readline().split()))

emerge = False
for i in range(n):
  # Find points on diameter perpendicular to (dx,dy):
  l = math.sqrt(dx*dx+dy*dy)
  u = Pt(dx/l,dy/l) # unit vector

  t1 = Pt(sx+rad*u.y,sy-rad*u.x) # "right" pt
  t2 = Pt(sx-rad*u.y,sy+rad*u.x) # "left" pt

  p1 = Pt(t1.x+dx,t1.y+dy)
  p2 = Pt(t2.x+dx,t2.y+dy)

  # t1->p1 and t2->p2 are rays tangent to the circle and aligned with dx,dy

  if inter(t1,p1,p[i],p[i+1]):
    emerge = True
  elif inter(t2,p2,p[i],p[i+1]):
    emerge = True
  elif dx == 0: # check for edge completely inside circle path: vertical case 
     if t2.x <= p[i].x and p[i].x <= t1.x and\
        t2.x <= p[i+1].x and p[i+1].x <= t1.x:
        emerge = True
  else: # non-vertical case
     a = -dy
     b = dx
     lim1 = a*t1.x + b*t1.y
     lim2 = a*t2.x + b*t2.y
     m = min(lim1,lim2)
     M = max(lim1,lim2)
     test1 = a*p[i].x + b*p[i].y
     test2 = a*p[i+1].x + b*p[i+1].y
     if test1 >= m and test1 <= M and test2 >= m and test2 <= M:
       emerge = True

if emerge:
  sys.exit(42)
else:
  sys.exit(43)
